function errtt(x,eabs,kx,uw,tcc)
% ERRTT ... time-domain functions error test
%
%	Call :		errtt( x, eabs, kx, uw ) ;
%
%	where :		   x --> system order, default 1
%			eabs --> absolute error flag, default 0
%			  kx --> error amplifying factor default 100
%			  uw --> unwindowed response plot, default 0

% RXon, 000309

if nargin < 5
	tcc = 1 ;
end
if nargin < 4
	uw = 0 ;
end
if nargin < 3
	kx = 100 ;
end
if nargin < 2
	eabs = 0 ;
end
if ~nargin
	x=1;
end

n=256;
m=8;
[z,p]=buttap(x);
w=(0:1:n-1)/m;
H=freqw(z,p,w);

[a,t]=ttresp(H,w,'u',0,1);
b=ttresp(H,m,'i',0,1);
% c=ttresp(H,m,'s',0,1);
c=cumsum(b*t(2));

h=ttresp(H,m,'u',0,0);
k=ttresp(H,m,'i',0,0);
% l=ttresp(H,m,'s',0,0);
l=cumsum(k*t(2));

tdc=t(2)/2;
tdc=tdc/tcc;

if x == 1
	f=exp(-t);
	e=f*t(2);
	g=1-f;
% elseif x == 2
%	% Butterworth system
%	T=sqrt(2);
%	phi=0.785;
%	% g=1-T*exp(-t/T).*sin(t/T+phi);
%	g=1-T*exp(-(t+tdc)/T).*sin((t+tdc)/T+phi);
%	e=1-T*exp(-(t-tdc)/T).*sin((t-tdc)/T+phi);
%	e=diff(e);
%	e=[e,e(n-1)];
%	f=e*n/(2*pi*m);
%
	% Bessel system
	% c=1-2*exp(-1.5*t/T).*sin(0.866*t/T+0.524);
else
	e=tdr(z,p,t,'n');
	f=tdr(z,p,t,'i');
	g=tdr(z,p,t+tdc,'s');
end

if eabs
	eru=kx*abs(a-e);
	eri=kx*abs(b-f);
	ers=kx*abs(c-g);
	wru=kx*abs(h-e);
	wri=kx*abs(k-f);
	wrs=kx*abs(l-g);
else
	eru=kx*(a-e);
	eri=kx*(b-f);
	ers=kx*(c-g);
	wru=kx*(h-e);
	wri=kx*(k-f);
	wrs=kx*(l-g);
end

q=51;
% q=20;

figure(1)
if uw
	plot( t(1:q),   f(1:q), '-g', ...
	      t(1:q),   b(1:q), '-r', ...
	      t(1:q),   k(1:q), '-b', ...
	      t(1:q), eri(1:q), '-k', ...
	      t(1:q), wri(1:q), '-m')
else
	plot( t(1:q),   f(1:q), '-r', ...
	      t(1:q),   b(1:q), '-b', ...
	      t(1:q), eri(1:q), '-k')
	% plot(t(1:q),b(1:q),'-r',t(1:q),eri(1:q),'-b')
end
xlabel('Time')
ylabel('Amplitude and error [%]')
if x == 1
	title(['Fig. 6.5.1 :  1st-order impulse response and error'])
elseif x == 2
	title(['Fig. 6.6.1 :  2nd-order impulse response and error'])
else
	title(['Fig. 6.6.3 :  Impulse response and error'])
end
axh=gca;
xlh=get(axh,'XLabel');
pos=get(xlh,'Position');
set(xlh,'Position',[0.8*pos(1), pos(2)]);
ylh=get(axh,'Ylabel');
pos=get(ylh,'Position');
set(ylh,'Position',[pos(1),0.5*pos(2)]);
tth=get(axh,'Title');
pos=get(tth,'Position');
set(tth,'Position',[0.4*pos(1),pos(2)]);

figure(2)
if uw
	plot( t(1:q),   g(1:q), '-g', ...
	      t(1:q),   c(1:q), '-r', ...
	      t(1:q),   l(1:q), '-b', ...
	      t(1:q), ers(1:q), '-k', ...
	      t(1:q), wrs(1:q), '-m')
else
	plot( t(1:q),   g(1:q), '-r', ...
	      t(1:q),   c(1:q), '-b', ...
	      t(1:q), ers(1:q), '-k')
	% plot(t(1:q),c(1:q),'-r',t(1:q),ers(1:q),'-b')
end
xlabel('Time')
ylabel('Amplitude and error [%]')
if x == 1
	title('Fig. 6.5.2 :  1st-order step response and error')
elseif x == 2
	title('Fig. 6.6.2 :  2nd-order step response and error')
else
	title('Fig. 6.6.4 :  Step response and error')
end
axh=gca;
xlh=get(axh,'XLabel');
pos=get(xlh,'Position');
set(xlh,'Position',[0.8*pos(1), pos(2)]);
ylh=get(axh,'Ylabel');
pos=get(ylh,'Position');
set(ylh,'Position',[pos(1),0.5*pos(2)]);
tth=get(axh,'Title');
pos=get(tth,'Position');
set(tth,'Position',[0.4*pos(1),pos(2)]);


% axh=gca;
% xlh=get(axh,'XLabel');
% set(xlh,'HorizontalAlignment','right');
% ylh=get(axh,'Ylabel');
% set(ylh,'HorizontalAlignment','right');
% tth=get(axh,'Title');
% set(tth,'HorizontalAlignment','right');
