function fig64w
% Fig. 6.4. Window example for 1st-order system.

% RXon, 000215

N=256;
m=8;
z=[];
p=-1;
w=(0:1:N-1)/m;

F=freqw(z,p,w);

% Hanning window
% W=(1+cos( (pi/2)*(0:1:N-1)/(N-1) ) )/2 ;

% Hamming window
% W=hamming(2*N);
% W=W(N+1:2*N).';
W=0.54-0.46*cos(2*pi*(N+1:1:2*N)/(2*N));

plot(w,abs(F),'-r',w,W,'-g',w,abs(W.*F),'-b')
text(10,-0.1, 'Frequency [w=(0:1:255)/8]')
text( 2, 1.05, 'Fig. 6.4. : Windowing of 1st-order system magnitude' )
text( 10, 0.8, 'W' ) ;
text( 10, 0.15, 'abs(F(jw))' ) ;
text( 2, 0.05, 'abs(W*F(jw))' ) ;