function fig65a
% Fig. 6.5.1-2
%	Bessel-Thomson systems from 9th to 1st order.
%	Step responses.

figure(1);
w=(0:1:255)/2;
for N = 9:-1:1
	[z,p]=bestap(N,'t');
	H=freqw(z,p,w);
	[S,t]=tresp(H,w,'s');
	% x=102 ;
	x=62 ;
	t=t(1:x);
	S=S(1:x);
	plot(t,S,'-r')
	hold on
end
xlabel('Time')
ylabel('Amplitude')
title('Fig. 6.7 :  Bessel system step-response')
axh=gca;
xlh=get(axh,'XLabel');
pos=get(xlh,'Position');
set(xlh,'Position',[0.8*pos(1), pos(2)]);
ylh=get(axh,'Ylabel');
pos=get(ylh,'Position');
set(ylh,'Position',[pos(1),0.5*pos(2)]);
tth=get(axh,'Title');
pos=get(tth,'Position');
set(tth,'Position',[0.4*pos(1),pos(2)]);



