function fig66
% Fig. 6.6.
%	Bessel-Thomson systems from 1st to 10th order.
%	Step responses.

matver = version ;
matver = str2num( matver(1) ) ;

figure(1);
w=(0:1:255)/2;
for k = 10:-1:1
	[z,p]=bestap(k,'t');
	H=freqw(z,p,w);
	if k == 10
		[S,t]=tresp(H,w,'s');
		x=min( find( t > 3 ) ) - 1 ;
		t=t(1:x);
	else
		S=tresp(H,w,'s');
	end		
	S=S(1:x);
	q=find(S<0);
	if ~isempty(q)
		disp(['S(',num2str(k),') < 0 between ',num2str(min(q))', ' and ', num2str(max(q)), '   min(S) = ', num2str(min(S))]);
	end
	plot(t,S,'-b')
	hold on
end

if matver == 4
	text( 1.35, -0.12, 'Time' )
	text( 0.4, 1.26, 'Fig.6.6.: Bessel systems of order 1 to 10' )
else
	xlabel( 'Time' )
	title( 'Fig.6.6.: Bessel systems of order 1 to 10' )
end
if matver == 5
	axis([0,3,0,1.2]);
end   