function [y,t]=qtresp(F,w,r,g)
%TRESP   Transient RESPonse, using Fast-Fourier-Transform algorhythm.
%
%	Call : [y,t]=tresp(F,w,r,g);
%
%	where: F is a 2^N length vector of complex-frequency response
%		 w is the related frequency vector of F
%		 r is a character, selects the response type returned in y:
%		 - 'u' is the unity-area impulse response (the default)
%		 - 'i' is the ideal impulse response
%		 - 's' is the step response
%		 g is an optional input argument; if present, plot the response.
%		 y is the selected system response
%		 t is the normalized time-scale vector.

%	Erik Margan, 880414, Last revision 000218

% ----------- Preparation and check of input data ; ----------------
if nargin < 3
	r='u';				% default response selector ;
end
M=abs(F(1));				% find system d.c. gain ;
n=max(size(F));				% find number of input points ;
nw=max(size(w));			% length of w ;
if nw == 1
	m=w;				% w is the normalized frequency unit ;
else
	if nw ~= n
		error('F and w must be of equal length !');
	else
		m=find(abs(w-1)==min(abs(w-1)))-1; % find the norm. freq. unit;
		if isempty(m)
			m = 0 ;		% could not find it ;
		end
	end
end
if m == 0
	m=max(find(abs(F)>=M/sqrt(2)))-1; % try to find it from half-power bandwidth ;
end

x=0;
A=abs(F(1+10*m));			% check the magnitude a decade above cut-off
if A > 0.05*M
	x=1;				% F is probably the first-order system f.r.;
elseif A > 0.005*M
	x=2;				% F is probably the second-order system f.r.;
end

% ----------- Normalize the time-scale ; ---------------------------
dt=2*pi*m/n;				% calculate delta_t ;
if nw == n
	dt=dt/w(m+1);			% correct for actual cut-off freq.;
end
t=dt*(0:1:n-1);				% form normalized time scale ;

% ----------- Form window function ; -------------------------------
if x
	H=(1+cos(pi*(0:1:n-1)/(n-1)))/2; % right-half Hanning window ;
	F=H.*F;				% frequency response windowed ;
end

% ----------- Calculate impulse response ; -------------------------
y=2*real(fft(conj(F)));			% calculate inverse Fourier transform ;
y=y-M;					% null "d.c.offset" ;
y=y/n;					% normalize area to M ;

% ----------- Calculate step response ; ----------------------------
if r == 's' | r == 'S'
%	if x == 1
%		er1=y(1);
%		y(1)=dt;
%		y=y*(1-(dt-er1))*n/(n-2);
%		y=[0,y(1:n-1)];		% force low-pass response causal ;
%	end
	y=cumsum(y);			% integrate to get the step resp. ;
	if x == 1
		y=(y-y(1))/(1-y(1));	% force low-pass response causal ;
	end
end

% ----------- Normalize Amplitude to Ideal ; -----------------------
if r == 'i' | r == 'I'
	if x==1
		y(1)=2*pi*m/n;		% correct first-point for first-order system;
	end
	y=y*n/(2*pi*m);			% normalize impulse amplitude ;
	% y=[0, y(1:n-1)];		% force impulse response causal ;
end

% ----------- Display results ; ------------------------------------
if nargin == 4
	plot( t, y, '-r' )
	title('Transient responses')
	xlabel('Time')
end
