% script :  test symbols in text
% ----- Bode-plot : single-side complex-frequency complex response ----- ;
[z,p]=buttap(5) ;
figh=0 ;
figh=figure(figh+1) ;
w=logspace(-3,1,601);		% 601 frequency points, equally spaced in ;
									% 3-decade log scale from 0.01 to 10 ;
H=freqw(z,p,w);				% 601 points of complex frequency response ;
Q=(pi/2)+(-0.2:0.02:pi/3);	% arc from pi/2 to pi/2+pi/3 ;

plot([-1,1], [0,0], '-k',...
     [0,0], [-1,1], '-k',...
     0.25*sin(Q), 0.25*cos(Q), '-b',...
     1, 0, 'ob',...
     -0.5, 0.5, 'ob',...
     0, 0, 'ob',...
     [0,real(H(350))], [0,imag(H(350))], '-b',...
     real(H), imag(H), '-r')
  
axis('square')
axis('manual')
hold on
text(0.4, 0.07, 'Real(H)');
text(0.05, 0.8, 'Imag(H)');
text( 0.25, -0.1, 'atan(Im(H)/Re(H))' );
text( 0.3, -0.5, 'abs(H)' );

% text( 1.03, 0.1, 'w=0' );
txh=text(1.03,0.1, 'w');
set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) ); % display 'omega'
text( 1.13, 0.1, '= 0');

% text( -0.75, 0.55, 'w=1' );
txh=text( -0.75, 0.55, 'w');
set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) ); % display 'omega'
text( -0.65, 0.55, '= 1');

% text( -0.3, -0.15, 'w=inf' )
txh=text( -0.30, 0.06, 'w');
set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) ); % display 'omega'
text( -0.20, 0.06, '=');
txh=text( -0.12, 0.06, '8');
set( txh,'FontName','BCSYMA','FontSize',16,'String',setstr(95) ); % display 'infinity'

% title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot'])
text(-1,1.05,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot'])
hold off
axis('auto')

