function mfbfilrc(N,Br,Bws,sg,psel,gt)
% MFBFILRC	R & C values for the Nth-order analogue part of the
%		(2N+1)th-order compound a+d system.
%
%	Call :		mfbfilrc(N,Br,Bws,sg,psel,gt);
%			
%	where :		N ...... analogue system order number (odd, min. 3)
%			Br ..... ADC bit resolution ( 12 by default )
%			Bws .... Bandwidth shift factor ( 1.2 - 1.9 ; 1.73 by def.)
%			sg ..... system gain ( min. 1 ; 100 y default )
%			psel ... pole selection flag ( 1 ==> 1 + last N-1 )
%						     ( 0 ==> 1 + every other cplx-pair )
%			gt ..... graphic test frequency-response plot flag ( 0 by default )

% RXon, 000417

if nargin < 6
	gt = 0 ;
end
if nargin < 5
	psel = 0 ;
end
if nargin < 4
	sg = 100 ;
end
if nargin < 3
	Bws = 1.73 ;
end
if nargin < 2
	Br = 12 ;
end
if nargin < 1
	N = 5 ;
end

if floor(N/2) == N/2
	N=N+1;
	disp('-------- WARNING : -----------------------------');
	disp(['System order shouldbe odd ! Working with N=', num2str(N)]);
end

M=2*N+1;			% compound a+d system order
fs=2e+6;			% system sampling frequency, 2MHz ;
fn=fs/2;			% Nyquist frequency ;
Ar=1/2^(round(abs(Br)));	% resolution level ;

% Nth-order system asymptote, crossing Ar at fn, has the corner frequency at :
fa=fn/10^( ( log10( (1/Ar)^2 - 1 ) ) / ( 2 * N ) ) ;

% (2*N+1)th-order Bessel-Thomson system poles, asymptote-normalized :
[z3,p3]=bestap(M,'a');
p3=sort(p3);

% shift the poles to actual system frequency ;
p3=p3*fa*Bws;

% select the N poles for the analogue-part ;
if psel
	p2=p3([1,(N+1:1:M)]);
	p1=p3([(2:1:N)]);
else
	xp(1,:)=2+(2:4:M-3);
	xp(2,:)=1+(xp(1,:));
	xp=[1, xp(:).'];
	% xp,xp(2:N)-2,pause
	p2=p3([xp]);
	p1=p3([xp(2:N)-2]);
end
% p3,p2,p1,pause

% test system response :
if gt
	[z0,p0]=bestap(N,'a');
	w=logspace(5,7,401);
	F0=20*log10(abs(freqw(p0*fa,w)));
	F2=20*log10(abs(freqw(p2,w)));
	F1=20*log10(abs(freqw(p1,w)));
	F3=20*log10(abs(freqw(p3,w)));
	nb=max(find(F2>-80));
	nn=max(find(w<=fn));
	na=max(find(F2>20*log10(Ar)));
	Fa=F2(nn:na);
	semilogx( w(1:nn), F0(1:nn), '-k', ...
		  w(1:nb), F2(1:nb), '-r', ...
		  w(1:nb), F1(1:nb), '-b', ...
		  w(1:nn), F3(1:nn), '-m', ...
		  w(nn:na),      Fa, '-g', ...
		  fs-w(nn:na),   Fa, '-g', ...
		  fs-w(nn:na), 20*log10(Ar)-Fa, '-c', ...
		  w([1,401]),  20*log10(Ar)*[1,1], '-k')
	w30=max(find(F0>=-3.0103));
	w31=max(find(F3>=-3.0103));
	text( fs, -10, [' Bws = ', num2str(Bws)] ) ;
	text( fs, -15, [' Bwf = ', num2str(w(w31)/w(w30))] );
	text( fs, -20, [' Bw', num2str(N), ' = ', num2str(w(w30)/1e+3), ' kHz'] );
	text( fs, -25, ['Bw', num2str(M),' = ', num2str(w(w31)/1e+3), ' kHz'] );
end

% for actual R & C values multiply the poles by 2*pi :
p2=2*pi*p2;

% configuration : Multiple-Feedback type, 3+2+...+2 stages :
st=1+(N-3)/2;	% number of stages ;
Ao=sg^(1/st);	% gain per stage ;

% ------------ 3rd-orser stage : ------------
% General 3rd-order pole-defined polynomial :
%   1 / ( (s-s1) * (s-s2) * (s-s3) ) = 
% = 1 / ( s^3 - s^2*(s1+s2+s3) + s*(s1*s2+s1*s3+s2*s3) - s1*s2*s3 ) =
% = 1 / ( s^3 + s^2*x + s*y + z )
%
% x = -(s1 + s2 + s3) ;
% y = s1*s2 + s1*s3 + s2*s3 ;
% z = -(s1 * s2 * s3) ;
%
% Transfer function :
%			z  
% H(s) = -Ao ----------------------------
%	      p^3 + p^2 * x + p * y + z
%
% Ao=R2/(2*R);
% wo=z^(1/3);
% x=(2+1/(2*Ao))*(1/(R*C2))+(2/(R*C3));
% y=(3+1/Ao)*(1/(R^2*C2*C3))+(1/(2*Ao))*(1/(R^2*C1*C2));
% z=(1/Ao)*(1/(R^3 * C1 * C2 * C3);


x = -real( p2(1) + p2(2) + p2(3) ) ;
y =  real( p2(1) * p2(2) + p2(1) * p2(3) + p2(2) * p2(3) ) ;
z = -real( p2(1) * p2(2) * p2(3) ) ;

% -----------------------------------------------------------
% solve the general-form of the 3rd-order equation :
%
%	(C3)^3 + p * (C3)^2 + q * (C3) + r = 0
%
% Solutions form the "Active Filter Cook-Book" by E.Margan :
% -----------------------------------------------------------
R = 1000 ;
k=2*(3*Ao+1)/(4*Ao+1);	% corrected 000421
p=-2*y/(z*R);		% p=-2*y/z;
q=k*2*x/(z*R^2);	% q=k*2*x/z;
% r=-k*4/z;		% originally : r=+k*4/z;
r=k*4/(z*R^3);		% !!!---- sign ????----!!!!!
% p,q,r

% C3 = 4*r*p^3 - p^2 * q^2 - 18*p*q*r + 4*q^3 + 27*r^2 ;
% C3 = sqrt( -C3/((p^2 - 3*q)^3) ) / (9*C3) ;
% C3 = sqrt(3) * ( ( p^2 - 3*q )^(3/2) ) * ( 2*p^3 - 9*p*q + 27*r ) * C3 ;
% C3 = -(2/3) * sqrt( p^2 -3*q ) * sin( atan( C3 ) / 3 ) - p/3 ;

C3 = 4*(p^3)*r - (p^2)*(q^2) - 18*p*q*r + 4*(q^3) + 27*(r^2);
C3 = sqrt(-1) * ( 2*(p^3) - 9*p*q + 27*r ) / ( 3 * sqrt( 3 * C3 ) ) ;
C3 = -(2/3) * sqrt( (p^2) - 3*q ) * sin( (1/3) * atan( C3 ) ) - p/3 ;
if imag(C3) > 1e-5*real(C3)
	disp(['>>WARNING!!! :  C3 has an imaginary component !!!<<']);
	disp(['  imag(C3) = ', num2str( imag(C3) )]);
end
C3=real(C3);

C2 = (3+1/Ao) / ( y*C3*R^2 - (z/2)*C3^2*R^3 ) ;
% C2=real(C2);

C1 = 1 / ( z*Ao*C2*C3*R^3 ) ;			% from z !
% C1=real(C1);

% display and test :
disp(' ');
disp(' ------ 3rd-order stage : -----------------------------------');
disp(['  Ao = ', num2str(Ao), '   R1=R3=R4 = ',num2str(R), ' ohm     R2 = ', num2str(2*R*Ao),' ohm']);
disp(['  C3 = ', num2str(C3*1e+9), ' nF      C2 = ', num2str(C2*1e+9), ' nF    C1 = ', num2str(C1*1e+9), ' nF']);
disp(['  f3 = ', num2str((1e-3)/(2*pi*R*(Ao*C1*C2*C3)^(1/3))), ' kHz     fp = ', num2str((1e-3)*z^(1/3)/(2*pi)), ' kHz']);
disp(' ------------------------------------------------------------');

for lx = 2:st

	% ----------- xl-th 2dn-order stage -------------------------------
	% Ao = R2/R3 ;
	% R1=R3=R
	% wo = 1 / sqrt( Ao * R1*R3*C1*C2 ) ;
	% wo/Q = ( 2+1/Ao ) / ( R2*C2 ) ;
	%
	% Transfer function :
	%
	%       s1*s2                   s1*s2
	% ----------------- = --------------------------
	%   (s-s1)*(s-s2)      s^2 - s*(s1+s2) + s1*s2
	%

	np=2*lx;
	% np, pause
	C1 = ( -p2(np) - p2(np+1) ) / ( p2(np) * p2(np+1) * R * ( 2*Ao + 1 ) ) ;
	C2 = ( 2*Ao + 1 ) / ( Ao * R * ( -p2(np) - p2(np+1) ) ) ;

	% display and test :
	ordstr=['st';'nd';'rd';'th';'th';'th';'th';'th';'th'];
	disp([' ------ ',num2str(lx-1), ordstr(lx-1,:),' 2nd-order stage : -------------------------------']);
	disp(['  Ao = ', num2str(Ao), '      R1=R3 = ',num2str(R), ' ohm     R2 = ', num2str(R*Ao),' ohm']);
	disp(['  C2 = ', num2str(C2*1e+9), ' nF      C1 = ', num2str(C1*1e+9), ' nF']);
	disp(['  f3 = ', num2str((1e-3)/(2*pi*sqrt(Ao*R^2*C1*C2))), ' kHz     fp = ', num2str((1e-3)*sqrt(p2(np)*p2(np+1))/(2*pi)), ' kHz']);
	disp(' ------------------------------------------------------------');
end
