function fig61
% Fig. 6.1.X
% Complete 5th-order Butterworth system representation.

% RXon, 890112
% Last revision : 000130

[z,p]=buttap(5);	% a 5th order Butterworth system zeros and poles
[row,col]=size(p);

% ----- polar-coordinates pole loci ----- ;
figh=figure(1) ;
A=zeros(row,col);
B=atan(imag(p)./real(p));
C=-abs(p);
Q=[A,B];
Q=Q.';
Q=Q(:);
R=[A,C];
R=R.';
R=R(:);
polar( B, C, '*r')
hold on
polar( Q, R, '-r')
hold off
grid
% title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
% xlabel(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
text(-0.9,-1.25,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])
text(1.2,0,'Real(s)')
text(0,1.2,'Imag(s)')




% ----- cartesian-coordinates pole loci ----- ;
figh=figure(figh+1) ;
P=[p(:).'; zeros(size( p(:).' ) )];
P=P(:);
theta=(0:pi/180:2*pi);
% plot(real(P),imag(P),'-r', real(p),imag(p),'*r', [.99],[.99],'.i')
plot([-1.99,1.99],[0,0],'-k',...
     [0,0],[-1.99,1.99],'-k',...
     sin(0:pi/180:2*pi),cos(0:pi/180:2*pi),'-b',...
     real(P),imag(P),'-r',...
     real(p),imag(p),'*r')
axis('square')
text(1.2,0.20,'Real(s)')
text(0.1,1.75,'Imag(s)')
% title(['Fig. 6.1.',num2str(figh),'1. :  5th-order Butterworth Poles'])
text(-1.8,2.2,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Poles'])




% ----- 3-D Magnitude over the s-plane ----- ;
figh=figure(figh+1) ;
xyz( z, p, -2, 2, 12, 0 ) ;
axis([-2,0,-2,2,0,12]);
axh=gca;
set(axh,'ZTick',[0,4,8,12],'ZTickLabels',[' 0';' 4';' 8';'12']);
% xlabel( 'sigma=real(s)' )
txh=text(-1,-3,-1,'x');
set(txh,'FontName','BCSYMB','FontSize',16,'String',setstr(53)); % display 'sigma'
text(-1,-3,-1,'   = real(s)')

% ylabel( 'jw =j*imag(s)' )	% - change font to display 'omega' instead of [space]!!!
txh=text(0,0,-2,'  x');
set(txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(61)]); % display 'omega'
text(0,0,-2,'j    = j*imag(s)')

zlabel( 'abs(H)' )

% title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth s-Plane Magnitude'] )
text(-1.8,-1.8,14, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth s-Plane Magnitude'] )




% ----- 3-D Helix, complex-frequency complex response ----- ;  
figh=figure(figh+1) ;
jw=(-3:0.01:3);			% 601 frequency points, pos. and neg., linear scale
G=freqw(z,p,jw(301:601));	% 301 points of complex frequency response
G=[real(G(301:-1:2))-j*imag(G(301:-1:2)), G];	% full +/-3 freq.range
% plot( jw, real(G), '-r', jw, imag(G), '-b' ), pause
% figure ;
% plot( jw, abs(G), '-r', jw, ephd(angle(G)), '-b' ), pause
% figure ;
plot3([-3, 3], [0, 0], [0, 0], '-g',...
      [0, 0], [-1.5, 1.5], [0, 0], '-b',...
      [0, 0], [0, 0], [-1.5, 1.5], '-k',...
      jw, imag(G), real(G), '-r',...
      0, 0, 1, 'ok')
view(-40,20);
axis([-3,3,-1.5,1.5,-1.5,1.5]) ;
axh=gca ;
set(axh,'XTick',[-3,-2,-1,0,1,2,3],'XTickLabels',['-3';'-2';'-1';' 0';' 1';' 2';' 3']);
set(axh,'YTick',[-1.5,-1,-0.5,0,0.5,1,1.5],'YTickLabels',['-1.5';' -1 ';'-0.5';'  0 ';' 0.5';'  1 ';' 1.5']);

% text(3, 0.25, 0.1, 'j*omega')
txh=text(3,0.25,0.1, '  x');
set(txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(61)]); % display 'omega'
text(3,0.25,0.1,'j    ')

text(-1.5, 1.5, 0.25, 'Imag(H)')
text(0.1, 0, 1.35, 'Real(H)')

% title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Complex-Frequency Response'])
text(-3,1.5,1.8,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Complex-Frequency Response'])





% ----- Bode-plot : single-side complex-frequency complex response ----- ;
figh=figure(figh+1) ;
w=logspace(-3,1,601);	% 601 frequency points, equally spaced in
			% 3-decade log scale from 0.01 to 10 ;
H=freqw(z,p,w);		% 601 points of complex frequency response
Q=(pi/2)+(-0.2:0.02:pi/3);
plot([-1,1], [0,0], '-k',...
     [0,0], [-1,1], '-k',...
     0.25*sin(Q), 0.25*cos(Q), '-b',...
     1, 0, 'ob',...
     -0.5, 0.5, 'ob',...
     0, 0, 'ob',...
     [0,real(H(350))], [0,imag(H(350))], '-b',...
     real(H), imag(H), '-r')
axis('square')
text(0.4, 0.07, 'Real(H)');
text(0.05, 0.8, 'Imag(H)');
text( 0.25, -0.1, 'atan(Im(H)/Re(H))' );
text( 0.3, -0.5, 'abs(H)' );

% text( 1.03, 0.1, 'w=0' );
txh=text(1.03,0.1, 'x ');
set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) ); % display 'omega'
text( 1.03, 0.1, '   = 0');

% text( -0.75, 0.55, 'w=1' );
txh=text( -0.75, 0.55, 'x ');
set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) ); % display 'omega'
text( -0.75, 0.55, '   = 1');

% text( -0.3, -0.15, 'w=inf' )
txh=text( -0.3, 0.06, 'x ');
set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) ); % display 'omega'
txh=text( -0.3, 0.06, 'w  = x ');
set( txh,'FontName','BCSYMA','FontSize',16,'String',['     ', setstr(95)] ); % display 'infinity'
text( -0.3, 0.05, '   =');

% title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot'])
text(-1,1.05,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot'])




% ----- Lin-lin Magnitude plot ----- ;
figh=figure(figh+1) ;
M=abs(H);		% magnitude
ix=max(find(w<=3));	% limit the frequecy scale to 3.
			% display M in lin-lin plot :
plot([w(1),w(ix)],[0.707,0.707],'-k',...
     [1,1],[0,1.2],'-k',...
     w(1:ix),M(1:ix),'-r')
text( 1.1, 0.74, '0.707' )
xlabel( 'Frequency' )
ylabel( 'Magnitude' )
% title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
text(0.2,1.25, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )



% ----- Nyquist plot : log10(f)-dB(M) ----- ; 
figh=figure(figh+1) ;
w=w(301:601);		% limit the frequency to -/+1decade
H=H(301:601);
M=abs(H);		% magnitude
% display M in dB vs. log-scale w
semilogx( w, 20*log10(M),'-r', [0.7, 1.4], [-3, -3], '-b', [1, 1], [0, -10], '-b' )
axis( [ 0.1, 10, -100, 0 ] ) ;
axh=gca;
set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
% xlabel( 'Frequency' )
text( 1.2, -95, 'Frequency' )
text( 0.6, -6, '-3dB' )
text( 3, -40, 'Slope :' )
text( 3.5, -50, '-100dB/10f' )
ylabel( 'Magnitude [dB]' )
% title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )
text(0.15,5, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude'] )




% ----- Nyquist plot : phase angle ----- ;
figh=figure(figh+1) ;
phi=angle(H);		% phase response, modulo +/-pi
semilogx([min(w),max(w)],[pi,pi],'--b',...
         [min(w),max(w)],[-pi,-pi],'--b',...
         w,phi,'-r')
axh=gca;
set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);

% xlabel( 'Frequency' )
text( 1.2, -3.6, 'Frequency' )

txh=text( max(w)/3, pi+0.25, '+pi' );
set( txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(49)] ); % display 'pi'
text( max(w)/3, pi+0.25, '+  ' );

txh=text( max(w)/3, -pi+0.25, '-pi' );
set( txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(49)] ); % display 'pi'
text( max(w)/3, -pi+0.25, '-  ' );

ylabel( 'Phase angle [rad]' )
% title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Phase'] )
text(0.15,4.4, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Phase'] )





% ----- phase angle unwrapped, in degrees ----- ;
figh=figure(figh+1) ;
alpha=ephd(phi);	% unwrapped
% display alpha in linear degrees
semilogx(w,180*alpha/pi,'-r')
axh=gca;
set(axh, 'YTick', [ -450, -360, -270, -180, -90, 0 ] ) ;
set(axh, 'YTickLabels', [ '-450'; '-360'; '-270'; '-180'; ' -90'; '   0' ] ) ;
set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);
% xlabel( 'Frequency' )
text( 1.2, -475, 'Frequency' )
ylabel( 'Phase angle [degrees]' )
% title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Unwrapped Phase'] )
text(0.15,20, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Unwrapped Phase'] )



% ----- group (envelope) time-delay ----- ;
figh=figure(figh+1) ;
tau=diff(alpha)./diff(w);		% time-delay
w=sqrt(w(2:1:301).*w(1:1:300));		% new w
semilogx(w,tau,'-r')			% plot
axh=gca;
set(axh,'XTickLabels',['0.1 ';'1.0 ';'10.0']);

% xlabel( 'Frequency' )
text( 1.2, -5.7, 'Frequency' )
ylabel( 'Time-Delay [s]' )
% title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Envelope-Delay'] )
text(0.15,0.25, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Envelope-Delay'] )
 



% ----- time-domain response : impulse and step function ----- ;
figh=figure(figh+1) ;
w=(0:1:255)/4;		% linear frequency vector
H=freqw(z,p,w);		% complex frequency response in new w ;
[S,I,t]=tresp(H,w);	% time-domain responses
nt=min( find( t > 20 ) ) - 1 ;	% limit time to 25*Tnorm
t=t(1:nt);
I=I(1:nt);
S=S(1:nt);
plot( t, I, '-r', t, S, '-b' )
text(8,0.15, 'Impulse-Response' )
text(8,0.85, 'Step-Response' )
xlabel( 'Time [s]' )
ylabel( 'Amplitude' )
% title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth in Time Domain'] )
text(0,1.3, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth in Time Domain'] )
