% Fig. 6.8
% Convolution example

[z1,p1]=butt(2);	% Butterworth 2nd-order system poles ;
[z2,p2]=best(2);	% Bessel-Thomson 2nd-order system poles ;

w=(0:1:255)/4;		% 256 point frequency vector, 5th point
 			% normalized to 1 ;

F1=freqw(p1,w);		% Butterworth system frequency response ;
F2=freqw(p2,w);		% Bessel-Thomson system frequency response ;

[S1,I1,t]=tresp(F1,w);	% step and impulse response of the Butterworth
 			% system with the normalized time vector ;
S2=tresp(F2,w);		% Bessel-Thomson system step response ;

y=vcon(I1(1:100),S2);	% convolution of the Bessel-Thomson system
 			% step response with the first 100 points of
 			% the Butterworth impulse response ;
plot(t,y(1:256),t,S2)	% plot the result and S2 verus time.