function fig62( scale )
% fig. 6.2
%	two-pole magnitude over s-plane.

if ~nargin
	scale = 3 ;
end

figure(1) ;
figure(2) ;
[ z, p ] = buttap( 2 ) ;
P=p(:).';
P=[P; zeros(size(P))];
P=P(:);
subplot( 2, 2, 1 ) ;
plot( real(p), imag(p), '*k',...
      real(P), imag(P), '-k',...
      scale*[-1 0 0 -1 -1], scale*[-1 -1 1 1 -1], '-k')
axis('square');
axis( ( scale + 1 ) * [ -1, 1, -1, 1 ] ) ;
title( 's-domain' )
xlabel( 'Real' )
ylabel( 'Imaginary' )

figure(1) ;
subplot( 1, 1, 1 ) ;
axis('normal')
axis('auto');
H = xyz( z, p, -scale, scale, scale ) ;
