function sig_y
% SIG_Y		Experimental.

% RXon, 000423

tt = 1 ;		% test-plot flag

fs=2e+6;		% sampling frequency
fN=fs/2;		% Nyquist frequency

T1=7.73e-5;	% signal exponential decay time
f1=1e+5;		% basic signal frequency
f3=3*f1;		% 3rd harmonic
f5=5*f1;		% 5th harmonic
f7=7*f1;		% 7th harmonic

t=(0:1:500)/fs;	% time scale
A1=0.035;			% basic signal amplitude
A3=A1/3;				% 3rd harmonic amplitude
A5=A1/5;				% 5th harmonic amplitude
A7=A1/7;				% 7th harmonic amplitude

% make signal from above data :
A=A1*sin(2*pi*f1*t);
A=A+A3*sin(2*pi*f3*t+0.001*pi/3);
A=A+A5*sin(2*pi*f5*t+0.001*pi/5);
% A=A+A7*sin(2*pi*f7*t+0.001*pi/7);
A=A.*exp(-t/T1);

% test plot :
if tt
   plot( t, A )
   title('Input signal')
   pause
end


T3=3e-6;
M=0.05*randn(1,501);
K=exp(-t/T3);
K=K/sum(K);
M=vcon(M,K);
M=M(1:501);

if tt
   plot( t, M )
   pause
end

figure(1);
plot(t,A,'-b',t,M-0.25,'-g')

Bws=1.73;
[z,p13]=bestap(13,'a');
p13=sort(p13);
f7a=fN/10^( ( log10( ( (2^12) )^2 - 1 ) ) / ( 2 * 7 ) ) ;
% disp(['   f7a = ', num2str( f7a*1e-3 ), ' kHz']),pause
p13=p13*f7a*Bws;

p7=p13([1,4,5,8,9,12,13]);
p6=p13([2,3,6,7,10,11]);

i7=atdr(z,p7,t(1:101),'n');
i6=atdr(z,p6,t(1:101),'n');

figure(2)
plot(t(1:101),i7,'-r',t(1:101),i6,'-b')

if 0
	C=vcon(A+M,i7);
else
	C=vcon(A,i7);
end
C=C(1:501);

D=vcon(C,i6);
D=D(1:501);

figure(3)
plot(t,C,'-r',t,D,'-b')

figure(4)
f=( 1/max(t) : 1/max(t) : fN ) ;
% f([1,50,100,150,200,250])

E=fft(C);
F=fft(D);
G=fft(A);
E=20*log10(abs(E(1:250)));
F=20*log10(abs(F(1:250)));
G=20*log10(abs(G(1:250)));
plot(f,E,'-r',f,F,'-b',f,G,'-g')

