% Xample1 :  Example 1 crates Fig.6.7.1, 6.7.2 and 6.7.3.

% Erik Margan, 981110, Free of copiright.

fo=1000; % [Hz]

[zb,pb]=buttap(5);
[zt,pt]=bestap(5,'n');

figure(1)
plot(real(pb), imag(pb), 'xr', real(pt), imag(pt), '+b')
axis([-2,2,-2,2]);
axis square ;
xlabel('real(s)');
ylabel('imag(s)');
title('Poles')

f=fo*logspace(-1,1,201);
w=2*pi*f;

% denormalize the poles and zeros (even if there are none!) :
zb=2*pi*fo*zb;
pb=2*pi*fo*pb;
zt=2*pi*fo*zt;
pt=2*pi*fo*pt;

Fb=freqw(zb,pb,w);
Ft=freqw(zt,pt,w);

figure(2)
loglog(f,abs(Fb),'-r',f,abs(Ft),'-b')
xlabel('f [Hz]')
title('Frequency response')
grid;

t=(0:0.05:3)/fo;
fb=atdr(zb,pb,t,'s');
ft=atdr(zt,pt,t,'s');

figure(3)
plot(t, fb, '-r', t, ft, '-b')
xlabel('t [ms]')
title('Step response')
grid;