function fig704
%FIG74	Generate Fig.7.4.1-3 for WBAmps, Part 7.
%
%	Show spectrum analysis and multiplication in frequency domain
%	as a substitute for convolution.

% RXon, 000402

w0=1000;			% frequency denormalization factor ;
N=1024;			% total vector length ;
m=64/w0;			% frequency scaling factor
w=(0:1:N-1)/m;	% frequency vector ;

[z,p]=bestap(5,'n');		% 5rd-order Bessel system ;
p=p*w0;			% half-power bandwidth is 1kHz ;
F=freqw(z,p,w);	% frequency response ;

% dt=2*pi*m/N;		% delta-t ;
dt=m/N;		% delta-t ;
t=dt*(0:1:N-1);	% time vector ;

% T1=67*dt;			% input signal exponential grow time ;
T2=35*dt;			% input signal exponential decay time ;
w1=1/(2.5*dt);	% input signal frequency ;
% g=((1-exp(-t/T1)).^2).*exp(-t/T2).*sin(w1*t);	% input function in time domain ;
g=exp(-t/T2).*sin(w1*t);	% input function in time domain ;
% h=hanning(179).';
% g(1:90)=g(1:90).*h(1:90);

% % g=[g(1:N/2) -g(1:N/2)];		% the signal repeats every N/2 with opposite phase ;

% % g=[-g(N/2:-1:1) g(1:N/2)];	% the signal repeats every N/2 with opposite phase ;
% % g=1000*(1-exp(-t/(1570*T))).*g;

% % g=sin(2*pi*t*f1);
% % g=g.*[zeros(1,N/4), hanning(N/4).', zeros(1,N/2)];

% ta je OK !!!
% g=g.*[hanning(7*15).', zeros(1,N-7*15)];

g=[zeros(1,N/8), g(1:N-N/8)];

figure(1)
x=max(find(t<=0.06));
plot( t(1:x), g(1:x), '-r' )
xlabel('Time [s]')
% axis([0, 0.06, -0.15, 0.15]);
% title('Input signal')

G=fft(g);			% G is spectrum of g ;

Y=F.*G;				% output spectrum ;
				% multiplication in frequency equals convolution in time ;

figure(2)
x=max(find(w<=5000));
M=max(abs(G));
plot( w(1:x), abs(F(1:x)), '-g', ...
      w(1:x), abs(G(1:x))/M, '-r', ...
      w(1:x), abs(Y(1:x))/M, '-b' )
xlabel('Frequency [Hz]'), ylabel('Normalized Magnitude');
% title('Magnitude Spectra')

y=2*(real(fft(conj(Y)))-1)/N;	% return to time domain and show result ;

figure(3)
a=max(find(t<=0.005));
b=min(find(t>=0.020));
plot( t(a:b), g(a:b), '-r', t(a:b), y(a:b), '-b' )
xlabel('Time [s]')
% axis([0.005, 0.025, -0.15, 0.15]);
% title('Input and Output Signals')

