function fig71
%FIG71	Generate Fig.7.1 - the convolution example for WBAmps, Part 7.
%
%	plot the 5th-order Butterworth impulse-response with a gated sinewave.

[z,p]=buttap(5);		% 5th-order Butterworth system ;
N=256;
m=4;
w=(0:1:N-1)/m;			% frequency vector ;
F=freqw(z,p,w);			% system frequency-response, evaluated at w ;
[I,t]=tresp(F,w,'u');		% unity-gain impulse response from F and w ;
d=200;
h=I(1:d);			% specify h as the first 200 points of I ;

plot(t(1:d),h), pause		% plot h vs t ;

				% x is the input signal : 25 zeros and
				% 225 points of sin(2pit/T) ;
b=25;
T=2*pi/(1.3*w(m+1));		% sinewave frequency is 1.3*(system half-power bandwidth)
x=[zeros(1,b), sin(2*pi*t(1:d+b)/T)];

				% plot h and x ;
plot( t(1:d+b), [zeros(1,b), h], '-r', t(1:d+2*b), x, '-g'), pause

y=vcon(h,x);			% convolve x with h ;
% y=conv(h,x);

				% plot convolution result
plot( t(1:d+b), [zeros(1,b), h/max(h)],'-r', ...
      t(1:d+2*b), x, '-g', ...
      t(1:d+2*b), y(1:d+2*b), '-b' )
