function fig71_0
% FIG71_0
% Convolution step-response example (P.S.)

% RXon, 000215

[z1,p1]=buttap(2);	% Butterworth 2nd-order system poles ;
[z2,p2]=bestap(2);	% Bessel-Thomson 2nd-order system poles ;

% w=(0:1:255)/4;		% 256 point frequency vector, 5th point
 							% normalized to 1 ;

% F1=freqw(p1,w);		% Butterworth system frequency response ;
% F2=freqw(p2,w);		% Bessel-Thomson system frequency response ;

% [I1,t]=tresp(F1,w,'u');	% step and impulse response of the Butterworth
 							% system with the normalized time vector ;
% S2=tresp(F2,w,'s');	% Bessel-Thomson system step response ;

t=(0:1:300)/20;		% time vector
I1=tdr(z1,p1,t,'n');	% Butterworth 2nd-order system impulse response
S2=tdr(z2,p2,t,'s');	% Bessel 2nd-order system step-response

x=max(find(t<=15));	% limit the time-scale to 15 ;
I1=I1(1:x);
% I1=I1/sum(I1);		% normalize impulse gain to unity ;

y=conv(I1,S2);
% y=vcon(I1(1:100,S2);	% convolution of the Bessel-Thomson system
 							% step response with the first 100 points of
 							% the Butterworth impulse response ;


% plot the result and S2 verus time :
plot(t(1:x),y(1:x),'-r',t(1:x),S2(1:x),'-b',t(1:x),I1/max(I1),'-g');
xlabel('Time');
text( 3, 1.3, 'Fig. 6.8. : Convolution example of S.1.X' );