function fig72
%FIG72	Generate Fig.7.2 - the convolution example-2 for WBAmps, Part 7.
%
%	plot the 5th-order Butterworth response to the unit-step.

[z,p]=buttap(5);		% 5th-order Butterworth system ;
N=256;
m=4;
w=(0:1:N-1)/m;			% frequency vector ;
F=freqw(z,p,w);			% system frequency-response, evaluated at w ;
[I,t]=tresp(F,w,'u');		% unity-gain impulse response from F and w ;
d=200;
h=I(1:d);			% specify h as the first 200 points of I ;

% --------- step-response test ---------------------------------------------
b=25;
				% x is the input signal : 25 zeros and 225 ones
x=[zeros(1,b) ones(1,d+b)];	% input unit-step function
nx=max(size(x));

y=vcon(h,x);			% convolve x with h ;

				% plot convolution result
plot( t(1:d+b), [zeros(1,b), h/max(h)],'-r', ...
      t(1:d+2*b), x, '-g', ...
      t(1:d+2*b), y(1:d+2*b), '-b' )
