function fig7241
%
%

% RXon, 010123

t=(0:1:200)/20;					% basic time vector, 201 samples
s=sin(2*pi*t/1.8).*exp(-t/2.3);	% exponentially decaying sinewave signal
s=[zeros(1,21), s(1:180)];	% shift the signal
s=s+0.027*randn(1,201); 		% make a noisy signal
[z,p]=bestap(5,'n');			% 5th-order Bessel filter poles
p=p*2*pi/t(21);					% denormalize the poles
h=atdr(z,p,t,'n');				% filter impulse response for convolution
y=vcon(s,h);						% filtering == convolution
y=y(1:201);						% limit convolution length
gdo=gdly(z,p,0);				% find the group-delay value
plot( t, s, '-g', t+gdo, y, '-b' )	% plot y delay-compensated 
