function [p7a,p6d]=fig76
%FIG76	Construction of Fig 7.5 and 7.6. for WBAmps, Part 7.
%	Plots the frequency-response and requiremendts for the improved 13th-order
%	system in fig.7.5. and the step-response comparison of the original 7th-order
%	filter and the improved 13th-order filter.
%	The function returns teh poles P7 selected for the 7th-order analogue-part
%	of the 13th-order compound (analogue+digital) filter.
%

% RXon, 000405

fn=1e+6;				% Nyquist frequency
fs=2*fn;				% sampling frequency

A=2^12;					% ADC resolution limit sets the attenuation
f7=fn*10^(log10(A^2-1)/(2*7));		% find frequency normalization factor
f7=fn*fn/f7;				% reverse it

[z7,p7]=bestap(7,'a');			% this is our original 7th-order reference
p7=f7*p7;				% denormalized poles of reference

[z13,p13]=bestap(13,'a');		% the 13th-order system
Bi=1.73;				% the bandwidth improvement factor
p13=Bi*f7*p13;				% denormalized poles of the compound system
p13=sort(p13);

p7a=p13([1,4,5,8,9,12,13]);		% analogue fiter pole selection
p6d=p13([2,3,6,7,10,11]);		% digital-equivalent filter poles
% p7a=p13([1,8,9,10,11,12,13]);		% analogue fiter pole selection
% p6d=p13([2,3,4,5,6,7]);		% digital-equivalent filter poles

f=logspace(5,7,301);			% 301-element log-scaled frequency vector

F70=20*log10(abs(freqw(p7,f)));		% refrence magnitude
F71=20*log10(abs(freqw(p7a,f)));	% analogue system magnitude
F6d=20*log10(abs(freqw(p6d,f)));	% digital-equivalent magnitude
F13=20*log10(abs(freqw(p13,f)));	% total a+d system magnitude

a=20*log10(1/A);		% the ADC resolution limit, -72dB
xa=max(find(F71>=a));		% response index at crossing of a
xn=151;				% index of the Nyquist frequency
fa=f(xn:xa);			% frequency at the index
Fa=F71(xn:xa);			% band above Nyquist
fb=fs-fa;			% alias of fa

% Fb=F71(xa:-1:xn);		% alias band
Fb=Fa;				% alias band

Frq=a-Fb;			% alias suppression requirement

r=max(find(F70>=-80));
s=max(find(F71>=-80));
t=max(find(F6d>=-80));
u=max(find(F13>=-80));
figure(1)
semilogx( f(1:r)/fn,  F70(1:r), '-k', ...
	  f(1:s)/fn,  F71(1:s), '-r', ...
	  f(1:t)/fn,  F6d(1:t), '-b', ...
	  f(1:u)/fn,  F13(1:u), '-m', ...
	  fa/fn,      Fa,       '-g', ...
	  fb/fn,      Fa,       '-g', ...
	  fb/fn,      Frq,      '-c', ...
	  [f(1),f(301)]/fn, [a,a], '--k' )
axh=gca;
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabels',[' 0.1';' 1.0';'10.0']);
xlabel('Frequency [MHz]')
ylabel('Magnitude [dB]')
text(4,-69, '-72dB')
text(0.4, -40, 'F70')
text(0.5, -23, 'F13')
text(0.4, -60, 'Fb')
text(2, -65, 'F6D')
text(1.2,-65, 'Fa')
text(1.0, -30, 'Frq')
text(0.6, -6, 'F71')

f30=f(max(find(F70>=-3)));
f31=f(max(find(F13>=-3)));
Bif=f31/f30;
disp([f30/fn, f31/fn,Bif])

figure(2)
t=(0:1:100)/fs;			% time vector
S70=atdr(z7,p7,t,'s');		% reference 7th-order system step-response
S13=atdr(z13,p13,t,'s');	% 13th-order step-response

% plot the step responses with the 0.1 and 0.9 reference levels,
% to aid rise-time identification :
plot( t*fn,           S70,     'r', ...
      t*fn,           S13,     'b', ...
      t([15 35])*fn,  [.1 .1], 'k', ...
      t([40 60])*fn,  [.9 .9], 'k' )
xlabel('Time [us]')
xt1=max(find(S70<=0.1));
xt2=max(find(S70<=0.9));
xt3=max(find(S13<=0.1));
xt4=max(find(S13<=0.9));
tr70=t(xt2)-t(xt1);
tr13=t(xt4)-t(xt3);
text(30,0.75,'Rise-times :')
text(30,0.60,['tr70=',num2str(tr70*fn),'us'])
text(30,0.45,['tr13=',num2str(tr13*fn),'us'])

figure(3)
% calculate the group delay for the original 7th- and improved 13th-order system :
gd70=groupdly(z7,p7,f);
gd13=groupdly(z13,p13,f);
semilogx( f/fn, gd70*1e+6, '-r', ...
	  f/fn, gd13*1e+6, '-b') %, ...
axh=gca;
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabels',[' 0.1';' 1.0';'10.0']);
xlabel( 'Frequency [MHz]' ) ;
ylabel( 'Group-Delay [us]' ) ;

p7a
p6d


% convolution as digital filtering :
l=50;
x7a=atdr( z7, p7a, t, 's' ) ;
h6d=atdr( z7, p6d, t, 'n' ) ;

figure(4)
plot(h6d(1:l)), pause

h6d=h6d(1:l);
y13=conv(x7a,h6d);
y13=y13(1:max(size(t)));

figure(5)
plot( t*1e+6, x7a, 'xr', t(1:l)*1e+6, 0.5*h6d/max(h6d), 'og', t*1e+6, y13, '*b' )
xlabel( 'Time [us]' )

