function fig7701(N,M)
% FIG7701		Test of double N-pole system against
%				a 2N-system. Step responses.

% RXon, 001229

if ~nargin
	N=2;
end

if nargin < 2
	M=N;
end

n=400;
t=(0:1:n)/20;

[z1,p1]=bestap(N,'n');
S1=atdr(z1,p1,t,'s');
[z2,p2]=bestap(M,'n');
I2=atdr(z2,p2,t,'n');
S2=conv(S1,I2);
S2=S2(1:n+1);

[z3,p3]=bestap(N+M,'n');
S3=atdr(z3,p3,t,'s');

figure(1);
plot(t,S1,'-r',t,I2*n/20,'-g',t,S2,'-m',t,S3,'-b')
x2=max(find(S2<=0.5));
xt=find(t==2*floor(1+ceil(t(2*x2))/2));
axis([0, t(xt), -0.2, 1.2]);

x1=max(find(S1<=0.5));
x2=max(find(S2<=0.5));
x3=max(find(S3<=0.5));
figure(2)
plot(t-t(x1),S1,'-r',t-t(x2),S2,'-m',t-t(x3),S3,'-b')
axis([-3,3,-0.2,1.2]);
