function y=sinww(N,fN)
% SINWW ... sin(w)/w plot.
%       Call : y = sinww(N,fN);
%       fN --> nyquist frequency
%       N  --> number of frequency samples

% RXon, 990217

if nargain < 2
    fN=1;       % Nyquist frequency
end
if nargin < 1
    N=601;      % number of frequency samples
end
f=logspace(-1,1,N);     % cycle-frequency vector
w=2*pi*f;       % angle-frequency vector
y=sin(w)./w;    % the function

figure(1)       % plot in linear vertical scale vs log frequency
semilogx(f,y,'-b',[f(1),f(N)],[0,0],'-k')

m=abs( sqrt(2)/2 - y ) ;    % find the cutoff frequency
x=find( m == min(m) ) ;     % index of the cutoff
fo = f(x) ;                 % the cutoff frequency
                % find the attenuation at the top frequency by
                % assuming a 0.1 attenuation factor per decade
y10=((0.1/10)*(log10(f(N))-log10(fo))) ;
figure(2)       % plot the function and the asymptote in log-log scale
loglog( f, abs(y), '-b', [fo, f(N)], [1, y10], '-k')
axis([0.1,10,0.01,1]);      % limit the vertical axis to 2 decades
