function sqwalias
% sqwalias

% RXon, 940321

fs = 2e+7 ;
fN = fs/2 ;
N = 2048 ;
f = fs * linspace(0,1,N);
w = 2*pi*f/fs;
y = [ 1, sin( w(2:N) )./( w(2:N) ) ];

x = find( y == min( y ) );
K = 5 ;
fq = f(x)/K ;
Tq = 1/fq ;

figure(1)
plot( f, y, '-g', f(x), y(x),'or',...
      fq, y(x/K), '*k', 3*fq, y(3*x/K), '*k', 5*fq, y(5*x/K), '*k' )

% whos
% return

y2 = ( y(1:N) + y(N:-1:1) ) ;
dt = 1/fs ;
t = dt*(0:1:N-1) ;
hq = sign(sin(2*pi*fq*t));

% whos
% return

figure(2)
plot( t, hq, '-r' );

Hq = fft(hq);
Fp = y2 .* Hq;
% Fp = y .* Hq;

% whos
% return

figure(3)
plot( f, abs(y),'-c',...
      f, abs(y(N:-1:1)),'-m',...
      f, abs(y2), '-g',...
      f, abs(Hq/N),'-r',...
      f, abs(Fp/N),'-b')

fp = real( ifft( Fp ) ) ;

% whos
% return

figure(4)
A = N/10 ;
B = A + 3*Tq/dt ;
plot(t(A:B),hq(A:B),'-r',t(A:B),fp(A:B),'-b')

whos

