% Time-delay compensation example - by pre-processing ;
% Script.
% Call :           td_comp2 ;

% Author : E.Margan, 1989.10.09.
% No copyright protection applied !

 N=201;				% number of original signal samples
 t=(0:1:N-1)/20;			% basic time vector, 201 samples
 s=cos(2*pi*t/1.8).*exp(-t/2.3); % exponentially decaying cos-wave signal
 s=s+0.027*randn(1,N); 		% make a noisy signal
 [z,p]=bestap(5,'n');		% 5th-order Bessel filter poles
 p=p*2*pi/t(21);			% denormalize the poles
 h=atdr(z,p,t,'n');		% filter impulse response for convolution
 nh=length(h);			% length of the filter impulse-response
 gdo=gdly(z,p,0);			% get the group-delay value
 x=max(find(t<=abs(gdo)));	% find gdo-time index
 V=sum(s(1:5))/5;			% average first 5 elements of the signal
 s=[V*ones(1,x+nh), s];		% extend the signal by the average value
 y=vcon(s,h);			% filtering == convolution
 y=y((nh+x+1):length(y));	% drop off the first x+nh elements
 y=y(1:N+x);			% and last nh-1 elements
 s=s((nh+1):length(s));		% drop off the first nh elements
 dt=t(2);				% find delta-t
 t=[dt*(-x:1:-1), t];		% extend the time vetor to the negative side
 plot( t, s, '-g', t, y, '-b' ) % plot s delay-compensated

