function sysview(z,p)
%SYSVIEW   SYSVIEW(z,p), where z and p are vectors of zeros and poles of the
%	system, will plot the complex-plane pole and zero locations and all
%	the resulting filter responses (attenuation, phase, group delay vs.
%	normalized frequency and impulse and step response vs. norm. time).
%	Try VIEW on results returned by one of the following ".M" - files:
%
%	BESTAP		(normalized Bessel-Thomson poles)
%	BUTTAP		(Butterworth poles)
%	CHEB1NP		(normalized Chebyschew type-1 poles)
%	CHEB2NP		(normalized Chebyschew type-2 poles and zeros)
%	ELLIPAP		(normalized Elliptic [Cauer] poles and zeros)
%
%	See also FAMILY and COMPFILT.

%	Erik Margan, November 11-th, 1988
%	Jozef Stefan Institute, Ljubljana, Slovenia
%	Not copyright protected !
%	Last revision : May 6th, 1992

z=z(:);
p=p(:);
nz=length(z);
np=length(p);

P=1e-6*ones(np,1);
P=[P(:),p];
P=P.';
P=P(:);
if all(real(P)) == 0
	P=P+1e-6;
end

figure(1);
if isempty(z) == 1
	polar( atan( imag(P)./real(P) ), sign( real(P) ).*abs(P), '-r')
	hold on
	polar(atan( imag(p)./real(p) ), sign( real(p) ).*abs(p), '*m' )
else
	Z(:)=1e-6*ones(size(abs(z)));
	Z(:,2)=z;
	Z=Z.';
	Z=Z(:);
	if all(real(Z)) == 0
		Z=Z+1e-6;
	end
	polar(atan( imag(P)./real(P) ), sign( real(P) ).*abs(P), '-r')
	hold on
	polar(atan( imag(p)./real(p) ), sign( real(p) ).*abs(p), '*m')
	polar(atan( imag(Z)./real(Z) ), sign( real(Z) ).*abs(Z), '-g')
	polar(atan( imag(z)./real(z+1e-6) ), sign( real(z+1e-6) ).*abs(z), 'oc')
	clear Z
end
clear P
grid
% pause
% hold off

figure(2);
% disp('Calculating frequency response...');
w=logspace(-1,1,300);

f=freqw(z,p,w);  % Calculate complex frequency response
% axis('square');
plot(-1,-1,'b',1,1,'b',real(f),imag(f),'-g')
	title('Complex frequency response')
	xlabel('Real')
	ylabel('Imaginary')
%	pause
% axis('normal');

mag=20*log10(abs(f));
clc
semilogx(w,mag,'-g')
	title('Attenuation')
	xlabel('Normalized frequency [Hz]')
	ylabel('Attenuation [ dB ]')
%	pause
% clg
% k=input('Zoom passbad details ? [Y/N; CR=Y] : ','s');
k=[];
if isempty(k) == 1
	k='Y';
end
figure(3);
if k == 'Y' | k == 'y' | k =='Z' | k == 'z'
	% x=abs(input('Enter maximum attenuation in dB [CR=3] : '));
	% if isempty(x) == 1
	%	x=3;
	% end
	semilogx(w,mag,'-g')
		title('Attenuation')
		xlabel('Normalized frequency [Hz]')
		ylabel('Attenuation [ dB ]')
	%	pause
	axis([0.1, 10, -3, 1]);
	% axis;
end
% clc
% clear mag

figure(4);
% phase=unwrap(angle(f),pi/3);	% doesn't work on Cheb.2 and Elliptic filters.
phase=ephd(angle(f));		% Works O.K.!
ph=180*phase/pi;
%	pphh=180*angle(f)/pi;	% Original to compare with.
%	semilogx(w,pphh,w,ph,'-g')
semilogx(w,ph,'-g')
	title('Phase shift')
	xlabel('Normalized frequency [Hz]')
	ylabel('Phase [ degrees ]')
%	pause
% clg
% clear ph

figure(5);
% disp('Calculating envelope delay ...')
nw=length(w);
td=((phase(2:1:nw)-phase(1:1:nw-1)))./(w(2:1:nw)-w(1:1:nw-1));
semilogx(sqrt(w(2:1:nw).*w(1:1:nw-1)),td,'-g')
	title('Envelope (Group) Delay')
	xlabel('Normalized frequency')
	ylabel('Normalized delay')
%	pause
M=-max(abs(td));
% clear w;
% clear f;
% clear mag;
% clear phase;
% clear nw;
% clear deltap;
% clear deltaw;
% clear td;
% clear P;

% clc;
figure(6);
disp('Calculating transient response ...');
% --- old routine begin --- ;
n=256;
m=8;
w=(0:1:n-1)/m;
F=freqw(z,p,w);
% H=(1+cos(pi*(0:1:n-1)/(n-1)))/2;
% F=H.*F;
% f=2*real(fft(conj(F)));
% if abs(F(1))~=0
% 	f=f-abs(F(1));
% end
% f=f/n;
[f,t]=tresp(F,w,'i',1);
% clear F;
% clear H;

% t=(0:1:n-1)/5;
% t=2*pi*
% a=10.24*(n/256)*(4/8);
% clc
% plot(t(1:xf),f(1:xf),'-g')
%	title('Impulse response')
%	xlabel('Normalized time');
%	pause

figure(7)
[f,t]=tresp(F,w,'s',1);
% f=cumsum(f(1:nt));
% if f(1)<0.5
%	f=(f-f(1))/(1-f(1));
% end
% plot(t(1:xf),f(1:xf),'-g')
%	title('Step response')
%	xlabel('Normalized time')

% --- old routine end --- ;

% --- new routine begin --- ;

% M,pause
% nt=301;
% t=(0:1:nt-1)/15;
% y=tdr(z,p,t,'i');
% plot(t,y,'-g')
% 	title('Impulse response')
%	xlabel('Normalized time')
% 	pause
% clc
% y=y/sum(y);
% y=cumsum(y);
% plot(t,y,'-g')
%	title('Step response')
%	xlabel('Normalized time')
% --- new routine end --- ;
