function C=capsch(x0,y0,ds,lbl)
% CAPSCH ... Capacitor circuit schematic plot.
%	     Used by "SCHEMA.M".
%	     Call :
%			C=capsch(x0,y0,ds,lbl) ;
%		
%		where:      C <-- returned end-point coordinates, C=[x0,y0,x1,y1] ;
%			x0,y0 --> starting coordinates
%			   ds --> direction string ( 'u', 'd', 'l', 'r' )
%			  lbl --> label, 'C' by default.

% RXon, 000625

CX1=[ 0,    3.25, 3.25, 3.25];
CY1=[ 0,    0,    1.5, -1.5  ];
CX2=[ 3.75, 3.75, 3.75, 7  ];
CY2=[-1.5,  1.5,  0,    0  ];

if nargin < 4
	lbl = 'C' ;
end
if nargin < 3
	ds = 'd' ;
end
lblx=CX1(3);
lbly=CY1(3)+0.5;

if strcmp(ds,'l')
	CX1=-CX1;
	CX2=-CX2;
	lblx=-lblx;
elseif strcmp(ds,'d')
	tmp=CX1;
	CX1=CY1;
	CY1=-tmp;
	tmp=CX2;
	CX2=CY2;
	CY2=-tmp;
	tmp=lblx;
	lblx=lbly;
	lbly=-tmp;
elseif strcmp(ds,'u')
	tmp=CX1;
	CX1=CY1;
	CY1=tmp;
	tmp=CX2;
	CX2=CY2;
	CY2=tmp;
	tmp=lblx;
	lblx=lbly;
	lbly=tmp;
end

line(x0+CX1,y0+CY1,'Color',[0,0,0]);
line(x0+CX2,y0+CY2,'Color',[0,0,0]);

C=[x0,y0,x0+CX2(max(size(CX2))),y0+CY2(max(size(CY2)))];
text( x0+lblx, y0+lbly, lbl ) ;
