function q=ephd(p)
%EPHD	Elliminate PHase Discontinuities. Outperforms UNWRAP and ADDTWOPI.
%	Use : q=ephd(p);
%	
%	p --> input phase vector in radians (range : -pi>p>+pi );
%	q --> output phase vector, "unwraped";
%	
%	If p is a matrix, unwraping is performed down each column.
%
%	See also PHASE and GROUPDLY.
%
%	Try the following example :
%		[z,p]=cheb2np(5,60);
%		w=logspace(-1,1,300);
%		F=freqw(z,p,w);
%		semilogx( w,angle(F), w,unwrap(angle(F))-0.1, w,ephd(angle(F))-0.2 )

%	Erik Margan
%	revised May 5th, 1992

[r,c]=size(p);
if min(r,c) == 1
	p=p(:);
	c=1;
end

q=diff(p);				% differetiate to find discontinuities
q=[zeros(c,1); pi*round(q/pi)];		% mark and round to correct level
q=cumsum(q);				% integrate back to generate compensation
q=p-q;					% subtract to cancell discontinuities

if r == 1
	q=q.';	% restore orientation.
end

%	"Ellegant, isn't it?"