function Y=lpf(y,N,p)
%LPF	Linear-phase Low-Pass Filter wih compensated filter time-delay.
%	
%	Y=lpf(y,N) returns the convolution of a N-th stage linear-phase
%	digital low-pass filter impulse response and the data vector y.
%	
%	Y=lpf(y,N,p), where p is an additional non-zero input argument,
%	will also plot the filtered data against the original.

%	Erik Margan, *911030*

Y=zeros(1, length(y)+2*N);
ny=length(y);
if ny < 2*N
	error('length(y) can''t be smaller than 2*N.')
end

h=hanning(N);

% c1=linreg(y(1:N));
c1=linreg(y(1:10));
add1=c1(1)*(-N+1:1:0)+c1(2);
% c2=linreg(y(ny-N+1:ny));
c2=linreg(y(ny-10+1:ny));
add2=c2(1)*(N+1:1:2*N)+c2(2);

y=[add1(:);y(:);add2(:)];

Y=filter(h/sum(h),1,y);
Y=Y(N+N/2+1:ny+N+N/2);		% Delay compensation!
y=y(N+1:ny+N);
if nargin == 3
	plot((0:1:ny-1),y,(0:1:ny-1),Y)
end
