function A=opampsch(x0,y0,ds,dflip,ug,lbl)
% OPAMPSCH ... Op-Amp circuit plot. Used by "SCHEMA.M".
%
%	Call :		A=poampsch(x0,y0,ds,dflip,ug,lbl);
%	where:		
%			A <-- returned coordinates of connection nodes :
%				A=[x0,y0,x1,y1,x2,y2];
%				x0,y0 - '+' input node
%				x1,y1 - '-' input node
%				x2,y2 - output node
%
%		     x0,y0 --> '+' input node coordinates, set the drawing origin ;
%		        ds --> direction string ( 'r', 'l', 'u', 'd' )
%		     dflip --> drawing flip ;  if 0, no flip
%				if 1 and ds is 'r' or 'l', flips about y-axis
%				else flips about x-axis.
%			ug --> unity-gain flag
%		       lbl --> Op-Amp label ; 'A' by default.

% RXon, 000625

AX1=[0, 2, 2, 8, 10];
AY1=[0, 0, 2, -2, -2];
AX2=[8, 2, 2, 0];
AY2=[-2, -6, -4, -4];
AX3=[2,2];
AY3=[-4,0];

if nargin < 5
	lbl = 'A' ;
end
if nargin < 4
	ug = 0 ;
end
if nargin < 3
	dflip = 0 ;
end
if nargin < 2
	ds = 'r' ;
end

if ug
	AX2=[AX2, 0, 10, 10];
	AY2=[AY2, -8, -8, -2];
end

lblxp = AX1(2)+0.5;
lblyp = AY1(2);
lblxn = AX1(2)+0.5;
lblyn = AY1(2)-4.0;
lblxa = AX1(2)+1.0;
lblya = AY1(2)-2.0;

if strcmp(ds,'r')
	if dflip
		AY1=-AY1;
		AY2=-AY2;
		AY3=-AY3;
		lblyn=-lblyn;
		lblya=-lblya;
	end
elseif strcmp(ds,'l')
	AX1=-AX1;
	AX2=-AX2;
	AX3=-Ax3;
	lblxp=-lblxp;
	lblxn=-lblxn;
	lblxa=-lblxa;
	if dflip
		AY1=-AY1;
		AY2=-AY2;
		AY3=-AY3;
		lblyn=-lblyn;
		lblya=-lblya;
	end
elseif strcmp(ds,'u')
	tmp=AX1;
	AX1=AY1;
	AY1=tmp;
	tmp=AX2;
	AX2=AY2;
	AY2=tmp;
	tmp=AX3;
	AX3=AY3;
	AY3=tmp;
	tmp=lblxp;
	lblxp=lblyp;
	lblyp=tmp;
	tmp=lblxn;
	lblxn=lblyn;
	lblyn=tmp;
	tmp=lblxa;
	lblxa=lblya;
	lblya=tmp;
	if dflip
		AX1=-AX1;
		AX2=-AX2;
		AX3=-AX3;
		lblxp=-lblxp;
		lblxn=-lblxn;
		lblxa=-lblxa;
	end
elseif strcmp(ds,'d')
	tmp=AX1;
	AX1=AY1;
	AY1=-tmp;
	tmp=AX2;
	AX2=AY2;
	AY2=-tmp;
	tmp=AX3;
	AX3=AY3;
	AY3=-tmp;
	tmp=lblxp;
	lblxp=lblyp;
	lblyp=-tmp;
	tmp=lblxn;
	lblxn=lblyn;
	lblyn=-tmp;
	tmp=lblxa;
	lblxa=lblya;
	lblya=-tmp;
	if dflip
		AX1=-AX1;
		AX2=-AX2;
		AX3=-AX3;
		lblxp=-lblxp;
		lblxn=-lblxn;
		lblxa=-lblxa;
	end
end

line(x0+AX1,y0+AY1,'Color',[0,0,0]);
line(x0+AX2,y0+AY2,'Color',[0,0,0]);
line(x0+AX3,y0+AY3,'Color',[0,0,0]);

A=[x0,y0,x0+AX2(4),y0+AY2(4),x0+AX1(5),y0+AY1(5)];

text( x0+lblxp, y0+lblyp, '+');
text( x0+lblxn, y0+lblyn, '-');
text( x0+lblxa, y0+lblya, lbl );
