function phi=phase(Z,P,w,f0)
% PHASE ...returns the phase angle of the system specified by
%	zeros Z and poles P for the frequency interval w :
%
%	phi=phase(Z,P,w);
%
%	Instead of calculating it as angle(freqw(Z,P,w)) which returns
%	the phase in modulo-pi (range +/-pi ), this is a direct
%	calculation, the result of which does not need to be
%	"unwrapped".
%
%	phi=phase(Z,P,w,f0)   returns the denormalized response.
%
%	See FREQW and GDLY.

%	Erik Margan, 890327
%	Institute Jozef Stefan, Ljubljana, Slovenia
%	Last revision :  980925

if nargin == 2
	w = P ;
	P = Z ;
	Z = [];		% A system with poles only.
end

if any( real( P ) > 0 )
	disp('WARNING :  This is not a Hurwitz-type system !' )
end

if all( w == i * imag( w ) )
	w = imag( w ) ;		% w must be real !
end

if nargin == 4
	w = 2 * pi * f0 *w ;	% denormalize to expected f0.
end	

n = length( P ) ;
m = length( Z ) ;

% find w orientation to return the result in the same form.
[ r, c ] = size( w ) ;
if c == 1
	w = w(:).' ;	% make it a row vector.
end

% calculate phase angle for each pole and zero and sum it columnwise.
phi( 1, : ) = -atan( ( imag( P(1) ) - w ) / real( P(1) ) ) ;
if n > 1
	for k = 2 : n
		phi( 2, : ) = -atan( ( imag( P(k) ) - w ) / real( P(k) ) ) ;
		phi( 1, : ) = sum( phi ) ;
	end
end

if m > 0
	for k = 1 : m
		phi( 2, : ) = atan( ( imag( Z(k) ) - w ) / real( Z(k) ) ) ;
		phi( 1, : ) = sum( phi ) ;
	end
end
if ( n > 1 ) | ( m > 0 )
	phi( 2, : ) = [] ;	% result is in phi(1,:) !
end

if c == 1
	phi = phi(:) ;		% restore form as w.
end
