function cplx_3p
% CLPX_3P

%

[z,p]=buttap(3);

a=3;
x=a*(-1:2/50:1);
y=x;
nx=length(x);

[X,Y]=meshgrid(x,y);
S=X+j*Y;
F=-prod(p)./((S-p(1)).*(S-p(2)).*(S-p(3)));

Fr=real(F);
Fi=imag(F);

% amplitude limiting for plot
for kx=1:nx
    for ky=1:nx
        
            if Fr(kx,ky) >= a
                Fr(kx,ky)=a;
            end
            if Fr(kx,ky) <= -a
                Fr(kx,ky)=-a;
            end
        
            if Fi(kx,ky) >= a
                Fi(kx,ky)=a;
            end
            if Fi(kx,ky) <= -a
                Fi(kx,ky)=-a;
            end
        
    end
end

figure(1)
surf( Fr, Y, Fi );

figure(2)
surf( X, Y, abs(Fr+j*Fi) );







