function cplxz
% Complex function F(z) test. Experimental.

% RXon, 010806

R=1.0;
phi=2*pi*(0:1:360)/360;

x=R*cos(phi);
y=R*sin(phi);
z=x+j*y;

F1=1 ./z;
% F2=(x./(x.^2+y.^2))-j*(y./(x.^2+y.^2));

plot3(                 x,                    y, zeros(1,length(phi)), '-g',...
                   1 ./x,                    y, zeros(1,length(phi)), '-b',...
                real(F1), zeros(1,length(phi)),             imag(F1), '-r',...
      [-2, 2, 2, -2, -2],   [-2, -2, 2, 2, -2],      [0, 0, 0, 0, 0], '-k',...
                  [0, 0],              [-2, 2],               [0, 0], '-k',...
                 [-2, 2],               [0, 0],               [0, 0], '-k',...
                  [0, 0],               [0, 0],              [-2, 2], '-k')

axis([-2,2,-2,2,-2,2]);
axis('square');
view([55,20]);
grid;
xlabel('1/\Re(\itz\rm) ;  \Re\{\itF\rm(\itz\rm)\}')
ylabel('\itj\rm\Im\{\itz\rm\}')
zlabel('\itj\rm\Im\{\itF\rm(\itz\rm)\}')

hold on
rmap=rainbow(length(phi)/4);
rmap=[rmap;rmap;rmap;rmap];
for k = 1 : length( phi )
	line( [ 1/x(k), real(F1(k))], [y(k), 0], [0, imag(F1(k))], 'color', rmap(k,:) );
end
