function xfr(z,p,h,q)
% XFR	compleX Frequency Response.
%
%		Call :			xfr(z,p,h);
%
%		where:			z --> system zeros
%						p --> system poles
%						h --> optional z-axis limit (default 20)
%		             q --> optional limit method: 1 - abs, 0 - Im,Re
%
%		xfr plots the real, imaginary complex and absolute values
%		of the system, determined by poles and zeros (if any) over
%		the complex frequency plane.
%		If there are no imput arguments, F(s)=1/s is ploted.

% RXon, 001021
% Last rev. : 001029

if nargin < 4
	q=0;
end
if nargin < 3
	h=10;
end
if nargin < 2
	if nargin < 1
		p=0;
		z=[];
	else
		p=[];
	end
end

if ~isempty(p)
	M=max(abs(p));
elseif ~isempty(z)
	M=max(abs(z));
else
	M=0;
end

d=ceil(M);
% if d == 0
%	d=1;
% end
d=d+1;
if d < 2
	d=2;
end

n=30;
% n=60;
a=d/n;

w=(-d:a:d);
% r=(-d:a:0);
r=(-d:a:d);

[x,y]=meshgrid(r,w);

if ~isempty(z)
	H=pats(z,x+j*y);
else
	H=ones(length(w),length(r));
end

if ~isempty(p)
	H=H./pats(p,x+j*y);
end

[c,r]=size(H);
if q
	for g=1:r
		k=find(abs(H(g,:))>h);
		H(g,k)=h*sign(H(g,k));
	end
else
	for g=1:r
		k=find(abs(real(H(g,:)))>h);
		H(g,k)=h*sign(real(H(g,k)))+j*imag(H(g,k));
		k=find(abs(imag(H(g,:)))>h);
		H(g,k)=real(H(g,k))+j*h*sign(imag(H(g,k)));
	end
end

figure(1);
% mesh(x,y,real(H))
surf(x,y,real(H))
axis([-d,d,-d,d,-h,h]);
view(50,25);
% title( [ '\itF\rm(\its\rm) = 1/\its' ] ) ;
xlabel( [ '\Re\{\its\rm\}' ] ) ;
ylabel( ['\Im\{\its\rm\}' ] ) ;
zlabel( ['\Re\{\itF\rm(\its\rm)\}' ] ) ;

figure(2);
% mesh(x,y,imag(H))
surf(x,y,imag(H))
axis([-d,d,-d,d,-h,h]);
view(50,25);
% title( [ '\itF\rm(\its\rm) = 1/\its' ] ) ;
xlabel( [ '\Re\{\its\rm\}' ] ) ;
ylabel( ['\Im\{\its\rm\}' ] ) ;
zlabel( ['\Im\{\itF\rm(\its\rm)\}' ] ) ;

figure(3);
% mesh(x+real(H),y,imag(H))
% surf(x+real(H),y,imag(H))
surf(real(H),y,imag(H))
% axis([-d,d,-d,d,-h,h]);
view(55,10);
% title( [ '\itF\rm(\its\rm) = 1/\its' ] ) ;
% xlabel( [ '\Re\{\its\rm\} + \Re\{\itF\rm(\its\rm)\}' ] ) ;
xlabel( [ '\Re\{\its\rm\} , \Re\{\itF\rm(\its\rm)\}' ] ) ;
ylabel( ['\Im\{\its\rm\}' ] ) ;
zlabel( ['\Im\{\itF\rm(\its\rm)\}' ] ) ;

for g=1:r
	k=find(abs(H(g,:))>0.8*h);
	H(g,k)=h*sign(H(g,k));
end

figure(4);
% mesh(x,y,abs(H))
surf(x,y,abs(H))
axis([-d,d,-d,d,0,h]);
% caxis([-h/5, h]);
caxis(h*[-0.2, 1.1]);
view(50,25);
% title( [ '\itF\rm(\its\rm) = 1/\its' ] ) ;
xlabel( [ '\Re\{\its\rm\}' ] ) ;
ylabel( ['\Im\{\its\rm\}' ] ) ;
zlabel( ['|\itF\rm(\its\rm)|' ] ) ;
