function xjw(z,p,n)
% XJW	compleX frequency response, s=c+j*w.
%
%		Call :			xjw(z,p,n);
%
%		where:			z --> system zeros
%						p --> system poles
%						n --> number of steps of c (def. 10)
%
%		xfr plots the complex frequency responses of the
%		system, determined by poles and zeros (if any) over
%		the complex frequency plane.
%		If there are no imput arguments, F(s)=1/s is ploted.

% RXon, 001021
% Last rev. : 001029

if nargin < 3
	n=5;
end
if nargin < 2
	if nargin < 1
		p=0;
		z=[];
	else
		p=[];
	end
end

m=20;
d=3;
b=d/200;
w=(-d:b:d);
g=length(w);

for k=0:1:m*n
	if ~isempty(z)
		eval( [ 'H', num2str(k), '=pats(z,k/n+j*w);' ] );
	else
		eval( [ 'H', num2str(k), '=ones(1,g);' ] );
	end

	if ~isempty(p)
		eval( [ 'H', num2str(k), '=H', num2str(k), ' ./ pats(p,k/n+j*w);' ] );
	end
end

plot3( [0,0],[-d,d],[0,0],'-k',...
       [0,0],[0,0],[-d,d],'-k',...
       [0,n],[0,0],[0,0],'-k');
axis([0,d,-d,d,-d,d]);
view(30,10);
% title( [ '\itF\rm(\its\rm) = 1/\its' ] ) ;
% xlabel( [ '\Re\{\its\rm\}' ] ) ;
xlabel( ['\Re\{\itF\rm(\its\rm)\}' ] ) ;
ylabel( ['\Im\{\its\rm\}' ] ) ;
zlabel( ['\Im\{\itF\rm(\its\rm)\}' ] ) ;
hold on

t=find(abs(H0)>d);
u=min(t);
v=max(t);
plot3( real(H0(1:u-1)), w(1:u-1), imag(H0(1:u-1)), '-b',...
       real(H0(1+v:g)), w(1+v:g), imag(H0(1+v:g)), '-b' );

for k = 1:1:m*n
	eval( [ 'plot3( real(H', num2str(k), '), w, imag(H', num2str(k), '), ''-b'' )' ] );
end
axis( 'equal' );
