function P=tcoilfit(N)
% TCOILFIT fits a polynomial of a chosen degree N
%          to the data for T-coil coupling coefficient
%          k as a function of the coil length-to-diameter
%          ratio (L/D)

if ~nargin
	N=3;
end
S=tcoilkld;
[P,Q]=polyfit(S(:,1),S(:,2),N);
x=logspace(-2,1,301);
y=polyval(P,x);
loglog(S(:,1),S(:,2),'-b',x,y,'-r')
