% Is(Tj) simulation

kB = 1.38e-23 ; % [VAs/K] Boltzmann constant

qe = -1.602e-19 ; % [C] electron charge

Isn = 1e-14 ; % [A] ; saturation current at T-nominal

Tn = 273 + 27 ; % [K]

Tmax = Tn + 163 ; % [K]

Tmin = Tn - 27 - 35 ; % [K]

Tj = Tmin : 5 : Tmax ;

Eg = 1.0 ; % [eV] ; effective energy gap for silicon

% saturation current model from SPICE
Is = Isn * ( ( Tj / Tn ).^3 ) .* ( exp( ( Eg * qe / kB ) * ( ( 1 ./Tj ) - ( 1 / Tn ) ) ) ) ;

% saturation current doubles approx. every 8 deg.C
% IsT = Isn * ( 1 + 2 .^( ( Tj - 273 ) / 8 ) ) ;
IsT = Isn * ( 2 .^( ( Tj - 293 ) / 8 ) ) ;

semilogy( Tj-273, Is, '-b', ...
          Tj-273, IsT, '-r' )

xlabel( 'Tj [ K - 273 ]' )
ylabel( 'Is [A]' ) ;
