% Pole interpolation

% RXon, 20020309

w=logspace(-1,1,201);
t=0:0.05:10;
[z,pt]=bestap(3,'a');
[z,pb]=buttap(3);
pt=cplxpair(pt);
pb=cplxpair(pb);

m=0.5;

rt=abs(pt);
rb=abs(pb);
yt=angle(pt);
yb=angle(pb);

rx=rt.^m;
yx=yb-m*(yb-yt);

px=rx.*exp(j*yx);

Fx=freqw(px,w);
Ft=freqw(pt,w);
Fb=freqw(pb,w);

figure(1)
loglog(w, abs(Ft), w, abs(Fx), w, abs(Fb));
axis([ 0.1, 10, 0.1, 2 ]);

figure(2)
qt=180*phase(z,pt,w)/pi;
qx=180*phase(z,px,w)/pi;
qb=180*phase(z,pb,w)/pi;
semilogx(w, qt, w, qx, w, qb);
axis([ 0.1, 10, -270, 0 ]);

figure(3)
dt=gdly(z,pt,w);
db=gdly(z,pb,w);
dx=gdly(z,px,w);
semilogx( w, dt, w, dx, w, db );

figure(4)
ht=atdr(z,pt,t,'s');
hx=atdr(z,px,t,'s');
hb=atdr(z,pb,t,'s');
plot( t, ht, t, hx, t, hb );
axis([ 0, 10, 0, 1.2 ]);


