function cfb(ppp)
%CFB	Current-FeedBack Amplifier equations test.
%	Trans-Impedance Equation :
%					Vo = Ie * Zt
%	Feedback Error Current :
%					Ie = Vi/Rp + (Vi-Vo)/Rs =
%					   = Vi*(Rs+Rp)/(Rs*Rp) - Vo/Rs
%	Trans-Impedance Model :
%					Zt = 1/(1/Rt + j*w*Ct)
%	Closed-Loop Gain :
%				     Vo/Vi = (1+Rs/Rp)/(1+Rs/Zt) =
%			= (1+Rs/Rp)/((1+Rs/Rt)*(1+j*w*Ct*Rs*Rt/(Rs+Rt)))
%	Open-Loop Gain :
%				     Vo/Vi = Rt/(Rp*(1+j*w*Ct*Rt))
%	Non-Ideal Closed-Loop Gain :
%	    Vo/Vi = 1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))))
%	Ie in time domain :
%	   Ie = Vi*(1/Rs+1/Rp)*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))))


%	E.M., 920702

subplot

Rp=300;			%[]
Rs=3000;		%[]
Rt=30000;		%[]
Ct=600*10^(-12);	%[F]
Rr=30;			%[]

f=logspace(3,6,301);
w=j*2*pi*f;
nt=161;
t=(0:1:nt-1)*10^(-7);
z=round(nt/8);
Vi1=ones(t);
Vi2=1-exp(-t/(Ct*Rs));
Vi3=1-exp(-t/(2*Ct*Rs));
G=4;
Vi1=G*Vi1;
Vi2=G*Vi2;
Vi3=G*Vi3;

Hc=(1+Rs/Rp) ./((1+Rs/Rt)*(1+w*Ct*Rs*Rt/(Rs+Rt)));
Ho=(Rt/Rp) ./(1+w*Ct*Rt);
% Hn=1 ./((Rr+Rs*Rp/(Rs+Rp))*(1/Rt+w*Ct+1/(Rs+Rp*Rr/(Rp+Rr))));
Hx=Hc ./(1+w*Ct*Rs);

semilogx(f,20*log10(abs(Ho)),'-c2',..
       f,20*log10(abs(Hc)),'-c3',..
       f,20*log10(abs(Hx)),'-c5')
%       f,20*log10(abs(Hn)),'-c4',..
pause
if nargin == 1
	meta cfbfr
end

t1=1000000*t;					%[s]
t1=t1-2;

% Impulse response, without input Rs*Ct
Vx=exp(-t/(Rs*Ct*Rt/(Rs+Rt)));
Vx=10*Vx/sum(Vx);
Vo1=conv(Vx,Vi1);
Vo1=[zeros(1:z) Vo1(1:nt-z)];
Vo2=conv(Vx,Vi2);
Vo2=[zeros(1:z) Vo2(1:nt-z)];
Vo3=conv(Vx,Vi3);
Vo3=[zeros(1:z) Vo3(1:nt-z)];
% subplot(121)
plot(t1,Vo1,'-c2',..
     t1,Vo2,'-c3',..
     t1,Vo3,'-c4',..
     0,41,0,-1)
% title('Step Response without input RC, with input RC and with 2RC')
% xlabel('Time [us]')
pause
if nargin == 1
	meta cfbsr
end

Ie1=(1/Rs+1/Rp)*Vi1.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie1=1000*([zeros(1:z+1) Ie1(1:nt-z-1)]);	%[mA]
Ie2=(1/Rs+1/Rp)*Vi2.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie2=1000*([zeros(1:z) Ie2(1:nt-z)]);		%[mA]
Ie3=(1/Rs+1/Rp)*Vi3.*(1-(1/(1+Rs/Rt))*(1-exp(-t*(Rs+Rt)/(Ct*Rs*Rt))));
Ie3=1000*([zeros(1:z) Ie3(1:nt-z)]);		%[mA]
plot(t1,Ie1,'-c2',..
     t1,Ie2,'-c3',..
     t1,Ie3,'-c4',..
     0,-1)

% title('Feedback Error Current Under Transient Condition')
% xlabel('Time [us]')
% ylabel('Current [mA]')
if nargin == 1
	meta cfbie
end
