function CFBAmpfx(Ro,Acl)
%

%

if nargin < 2
    Acl = [1.000000001, 10 100];
end
if nargin < 1
    Ro = 10 ;
end

Rf = 1000 ;
f = logspace( 6, 9, 31 ) ;
w = j*2*pi*f;

RT = 3e+5 ;
CT = 1.59e-12 ;
ZT = 1 ./( 1/RT + w*CT);

for k = 1:length(Acl)
    er=Acl(k)*Ro/RT + Rf/RT ;
    Re = Rf/(Acl(k)-1);
    s1 = (1+er)/(CT*(Rf+Ro*Acl(k))) ;
    Fx = (Acl(k)/(1+er))* s1 ./ (w + s1) ;
    loglog( f, abs(Fx)) ;
    hold on;
end
axis([1e+6,1e+9,1e-1,1e+2]);

