function a700
% A700		Amplifier, 7-pole, 2-stage ; maximize bandwidth.
%			Experimental. Comparison with the non-compensated
%			two real pole system.

% RXon, 20030314

[z,p] = bestap(7,'t');
% q = [ p(1) ; p(2) ; p(3) ; p(6) ; p(7) ; p(4) ; p(5) ] ;
% p = q ; 
[K,ix] = sort( abs(p) );
p = p(ix) ;

Da = p(1) ;
Db = real( p(3) ) / ( cos( angle( p(3) ) ) )^2 ;
Dc = real( p(5) ) / ( cos( angle( p(5) ) ) )^2 ;
Dd = real( p(7) ) / ( cos( angle( p(7) ) ) )^2 ;

f = logspace( 6, 9, 601 ) ;
t = 1e-9 * ( 0 : 0.05 : 25 ) ;

A = 10 ;
Cb = 11e-12 ;
Ca =  4e-12 ;
gm0 = 0.01 ;

% m = ( 0.7 : 0.1 : 1.3 ) ;
m=1;

for k = 1 : length(m)
	% Rb = sqrt( A ) / ( m(k) * gm0 ) ;
	Rb = 360 ;
	
	Cc = Cb * ( Db / Dc ) / 2 ;
	Cd = 4 * Ca * ( Da / Dd ) ;
	
	Ra = Rb * ( Db / Da ) * ( Cb / Ca ) / 4 ;
	
	Lb = Rb^2 * Cb ;
	Ld = Ra^2 * Cd ;
	Lc = Rb^2 * Cc / ( 4 * ( cos( angle( p(3) ) ) )^2 ) ;
	
	kb = ( 3 - ( tan( angle( p(3) ) ) )^2 ) / ( 5 + ( tan( angle( p(3) ) ) )^2 ) ;
	kd = ( 3 - ( tan( angle( p(7) ) ) )^2 ) / ( 5 + ( tan( angle( p(7) ) ) )^2 ) ;
	
	Cbb = Cb * ( 1 + ( tan( angle( p(3) ) ) )^2 ) / 16 ;
	Cbd = Cd * ( 1 + ( tan( angle( p(7) ) ) )^2 ) / 16 ;
	
	disp( [ num2str(k), ')' ] ) ;
	disp( '    Rb[k]     Ra[k]     Cc[pF]    Cd[pF]    Cbb[pF]   Cbd[pF]   ' ) ;
	disp( '---------------------------------------------------------------' ) ;
	disp( [ 1e-3*[ Rb, Ra], 1e+12*[ Cc, Cd, Cbb, Cbd ] ] ) ;
	disp( ' ' ) ;
	disp( '    Lb[uH]    Lc[uH]    Ld[uH]    kb        kd     ' ) ;
	disp( '---------------------------------------------------' ) ;
	disp( [ 1e+6*[ Lb, Lc, Ld ], kb, kd ] ) ;
	disp( ' ' ) ;  
	
	pa = -1 / ( Ra * Ca ) ;
	
	re = cos( angle( p(3) ) ) ;
	im = sin( angle( p(3) ) ) ;
	pb = [ -re + j*im ; -re - j*im ] ;
	pb = pb * 4 * cos( angle( p(3) ) ) / ( Rb * Cb ) ;
	
	re = cos( angle( p(5) ) ) ;
	im = sin( angle( p(5) ) ) ;
	pc = [ -re + j*im ; -re - j*im ] ;
	pc = pc * 2 * cos( angle( p(5) ) ) / ( Rb * Cc ) ;
	
	re = cos( angle( p(7) ) ) ;
	im = sin( angle( p(7) ) ) ;
	pd = [ -re + j*im ; -re - j*im ] ;
	pd = pd * 4 * cos( angle( p(7) ) ) / ( Ra * Cd ) ;
	
	q = [ pa ; pb ; pc ; pd ] ;
	
	p2 = [ -1/(Ra*(Ca+Cd)) ; -1/(Rb*(Cb+Cc)) ] ;
	
	figure(1)
%	plot( 1e+8*[-20,6], [0,0], '-k',...
%         [0, 0], 1e+8*[-11, 11], '-k',...
%         real(q), imag(q), '*b',...
%         real(p2), imag(p2), '*r' )
	% axis equal ;
%	axis(1e+8*[-21,8,-12,12]);
	polar( angle(q), abs(q), '*b' ) ;
	hold on ;
	polar( angle(p2), abs(p2), '*r' )
	grid ;
%	hold on ;
	
	F = freqw( z, q, 2*pi*f ) ;
	F2 = freqw( z, p2, 2*pi*f ) ;
	figure(2)
	loglog( f, abs( F ), '-b',...
           f, abs(F2), '-r',...
           [f(1), f(length(f))], [1, 1]/sqrt(2), '-k' )
	axis( [ 1e+6, 1e+9, 0.1, 2.0] ) ;
	grid ;
	hold on ;
	
	y = atdr( z, q, t ) ;
	y2 = atdr( z, p2, t ) ;
	figure(3)
	plot( 1e-9*[1, 5], [0.1, 0.1], '-k', ...
         1e-9*[6, 18], [0.9, 0.9], '-k', ...
         t, y, '-b', ...
         t, y2, '-r' )
	axis([0,25e-9,0,1.2]);
	grid ;
	hold on ;
	
	% gm1 = sqrt( A ) / Ra ;
	% gm2 = sqrt( A ) / Rb ;
    
    ix = find( abs( abs(F) - sqrt(2)/2 ) == min( abs( abs(F) - sqrt(2)/2 ) ) ) ;
    iy = find( abs( abs(F2) - sqrt(2)/2 ) == min( abs( abs(F2) - sqrt(2)/2 ) ) ) ;
    f(ix), f(iy)
    eta_b = f(ix)/f(iy)
    
    ix = find( abs( y-0.1 ) == min( abs( y-0.1 ) ) ) ;
    iy = find( abs( y-0.9 ) == min( abs( y-0.9 ) ) ) ;
    tr = t(iy) - t(ix)

    ix = find( abs( y2-0.1 ) == min( abs( y2-0.1 ) ) ) ;
    iy = find( abs( y2-0.9 ) == min( abs( y2-0.9 ) ) ) ;
    tr2 = t(iy) - t(ix)
    eta_r = tr2/tr
end
