function cfbampcc
% CFBAMPCC Current feedback amplifier capcitive compensation
%          and decompensation

f=logspace(6,9,301);
s=j*2*pi*f;

Rf=600;
Re=150;
Rt=5e+5;
Ct=1e-12;
Cf=1e-11;
Ce=3e-12;

Acl = 1 + Rf/Re;
err = 1 + Rf/Rt;
s1 = err/((Cf+Ct)*Rf);
Acd = Cf/(Cf+Ct);
s2 = err/(Ct*Rf);

Flp=(Acl/err)*(s1 ./(s+s1));
Fhp=Acd*s./(s+s1);
Fa=Flp+Fhp;
Fr=(Acl/err)*(err/(Ct*Rf))./(s+(err/(Ct*Rf)));

figure(1)
loglog( f, abs(Flp), f, abs(Fhp), f, abs(Fa), f, abs(Fr) )
figure(2)
semilogx( f, 180*angle(Flp)/pi, f, 180*angle(Fhp)/pi, f, 180*angle(Fa)/pi )
figure(3)
fx=sqrt( f(1:1:length(f)-1).*f(2:1:length(f)) );
semilogx( fx, diff(angle(Flp)), fx, diff(angle(Fhp)), fx, diff(angle(Fa)) )


Flp2=(Acl/err)*(s2 ./(s+s2));
Fhp2=(Ce/Ct)*s./(s+s2);
Fb=Flp2+Fhp2;

figure(4)
loglog( f, abs(Flp2), f, abs(Fhp2), f, Fb )
figure(5)
semilogx( f, 180*angle(Flp2)/pi, f, 180*angle(Fhp2)/pi, f, 180*angle(Fb)/pi )
figure(6)
semilogx( fx, diff(angle(Flp2)), fx, diff(angle(Fhp2)), fx, diff(angle(Fb)) )

figure(7)
Fx=(1+s*Cf*Rf+Rf/Re)./(1+s*(Cf+Ct)*Rf+Rf/Rt);
loglog( f, abs(Fx), f, abs(Fr) )

