% Fig 6.6.2. : Bessel-Thomson poles for systems of 2nd to 9th order

plot( [-2,6], [0,0], '-g', [0,0], [-4,4], '-g' )     
axis equal square ;
hold on
for k = 9:-1:1
	[z,p]=bestap(k,'t');
	[E,A]=efitpar(p) ;
	if k == 1
		plot(E(:,1),E(:,2),'-g',real(p),imag(p),'*b')
	else
		plot(E(:,1),E(:,2),'-r',real(p),imag(p),'*b')
	end
	% disp(['--> ', num2str(k),' ..... ', num2str(A(1))]);
end
xlabel( 'Real' )
ylabel( 'Imag' )
title( 'Fig.6.6.2. :  Bessel-Thomson poles (2nd to 9th-order systems)' )
