function fig615
% Fig. 6.1.X
% Complete 5th-order Butterworth system representation.

% RXon, 890112
% Last revision (Matlab-IV) : 000130
% Revision Matlab-V : 000819

% get Matlab version number :
if ~exist('version')
	matver='1.0';
else
	matver=version;
end
matver=str2num(matver(1));

[z,p]=buttap(5);	% a 5th order Butterworth system zeros and poles
[row,col]=size(p);


% -------------- Fig.6.1.5. -------------------------------------------- ;
% ----- Bode-plot : single-side complex-frequency complex response ----- ;
% figh=figure(figh+1) ;
figh=5;
figure(figh);
w=logspace(-3,1,601);	% 601 frequency points, equally spaced in
							% 3-decade log scale from 0.01 to 10 ;
H=freqw(z,p,w);			% 601 points of complex frequency response ;
Q=(pi/2)+(0:0.05*pi/3:pi/3);
plot([-1,1], [0,0], '-k',...
     [0,0], [-1,1], '-k',...
     0.23*sin(Q), 0.23*cos(Q), '-b',...
     1, 0, 'ob',...
     -0.5, 0.5, 'ob',...
     0, 0, 'ob',...
     real(H), imag(H), '-r')
axis('square')
axis('manual')
hold on

% deleted from the "plot"2 command above :
%     [0,real(H(380))], [0,imag(H(380))], '-b',...
% replaced by the "vector()" command :
vector( [ 0, 0, real(H(380)), imag(H(380)) ], 'b', 1.0 ) ;
vector( [ 0.24, -0.22, 0.22, -0.24 ]/sqrt(2), 'b', 0.2 ) ;

lh = line( [ 0.45, 0.75 ], [ 0.25, 0.25 ] ) ;
set( lh, 'Color', 'k', 'LineStyle', '-', 'LineWidth', 0.5 ) ;
vector( [ 0.75, 0.25, 0.95, 0.05 ], 'k', 0.5 ) ;

lh = line( [ -0.55, -0.25 ], [ -0.25, -0.25 ] ) ;
set( lh, 'Color', 'k', 'LineStyle', '-', 'LineWidth', 0.5 ) ;
vector( [ -0.25, -0.25, -0.05, -0.05 ], 'k', 0.5 ) ;

lh = line( [ -0.25, -0.75 ], [ 0.75, 0.75 ] ) ;
set( lh, 'Color', 'k', 'LineStyle', '-', 'LineWidth', 0.5 ) ;
vector( [ -0.75, 0.75, -0.55, 0.55 ], 'k', 0.5 ) ;

% axis labels :
if matver < 4
	text(0.3, 0.07, 'Real{F(jw)}');
	text(0.05, 0.8, 'Imag{F(jw)}');
elseif matver == 4
	txh=text(0.3, 0.07, 'Real{F(jw)}');
	set(txh,'FontAngle','Italic');
	txh=text(0.05, 0.8, 'Imag{F(jw)}');
	set(txh,'FontAngle','Italic');
else
	text(0.3, 0.07, '\Re\{{\itF}({\itj\omega})\}','FontSize',16);
	text(0.05, 0.8, '\Im\{{\itF}({\itj\omega})\}','FontSize',16);
end

% angle label :
if matver < 4
	text( 0.2, -0.1, 'atan(Im(F)/Re(F))' );
elseif matver == 4
	txh=text( 0.05, -0.1, 'x  ' );
	% display greek 'varphi' from BCSYMB (WinEXP) font, istead of x :
	set( txh, 'FontName', 'BCSYMB', 'FontSize', 16, 'String', setstr(58) ) ;
	text( 0.05, -0.1, '   = atan(Im(F)/Re(F))' );
else
	% original text :
	% text( 0.25, -0.15, '{\it\phi}={\itatan}(\Im({\itF}({\itj\omega}))/\Re({\itF}({\itj\omega})))' );
	
	% fraction midline :
	lh=line( [0.45, 0.95], [-0.2, -0.2] ) ;
	set( lh, 'LineStyle','-','Color','k' ) ;

	% txh=text( 0.05, -0.2, 'x ' ) ;
	txh=text( 0.1, -0.07, 'x ' ) ;
	% display greek 'varphi' from BCSYMB (WinEXP) font,
	% istead of x , since Matlab-V does not recognize varphi :
	set( txh, 'FontName', 'BCSYMB', 'FontSize', 16, 'String', setstr(58) ) ;

	% txh=text( 0.44, -0.2, '{\it\phi} = {\itatan}' );
	txh=text( 0.44, -0.2, '= {\itatan}' );
	set( txh, 'HorizontalAlignment','Right','FontSize',16 ) ;
	% numerator
	text( 0.48, -0.12, '\Im\{{\itF}({\itj\omega})\}','FontSize',16 );
	% denominator
	text( 0.48, -0.28, '\Re\{{\itF}({\itj\omega})\}','FontSize',16 );
end

% Magnitude label :
if matver < 4
	text( 0.3, -0.5, 'M(w)=|F(jw)|' );
elseif matver == 4
	txh=text( 0.3, -0.5, 'M(w)=|F(jw)|' );
	set(txh,'FontAngle','Italic');
else
	text( 0.3, -0.5, '{\itM}({\it\omega}) = |{\itF}({\itj\omega})|','FontSize',16 );
end

if matver < 4
	% text( 1.03, 0.1, 'w=0' );
	text( 0.5, 0.25, 'w=0' );
elseif matver == 4
	txh=text( 0.5, 0.25, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
	text( 0.5, 0.25, '   = 0');
else
	text( 0.5, 0.25, '{\it\omega} = 0','FontSize',16,'VerticalAlignment','Bottom');
	% text( 1.03, 0.08, '{\it\omega} = 0','FontSize',16);
	% text( 1.06, 0, '\leftarrow','FontSize',16 )
end

if matver < 4
	% text( -0.75, 0.55, 'w=1' );
	text( -0.65, 0.75, 'w=1' );
elseif matver == 4
	txh=text( -0.65, 0.75, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
	text( -0.65, 0.75, '   = 1');
else
	% txh=text( -0.5, 0.6, '\downarrow' ) ;
	% set( txh, 'HorizontalAlignment','center','FontSize',16 ) ;
	% text( -0.47, 0.7, '{\it\omega} = 1','FontSize',16);
	text( -0.65, 0.75, '{\it\omega} = 1','FontSize',16,'VerticalAlignment','Bottom');
end

if matver < 4
	% text( -0.3, -0.15, 'w=inf' );
	text( -0.5, -0.25, 'w=inf' );
elseif matver == 4
	% txh=text( -0.3, -0.06, 'x ');
	txh=text( -0.5, -0.25, 'x ');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMB','FontSize',16,'String',setstr(61) );
	% txh=text( -0.3, 0.06, '     x ');
	txh=text( -0.5, -0.25, '     x ');
	% display 'infinity' from BCSYMA (WinEXP) font, instead of x :
	set( txh,'FontName','BCSYMA','FontSize',16,'String',['     ', setstr(95)] );
	% text( -0.3, 0.05, '   =');
	text( -0.5, -0.25, '   =');
else
	text( -0.6, -0.25, '{\it\omega} = \infty','FontSize',16,'VerticalAlignment','Bottom');
	% text( -0.3, 0.1, '{\it\omega} = \infty','FontSize',16);
	% text( -0.17, -0.02, '\rightarrow','FontSize',16 ) ;
end

if matver < 4
	title(['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot']);
elseif matver == 4
	text(-1,1.05,['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Bode-Plot']);
else
	title(['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Bode-Plot']);
end

