function fig655_3(m,N,X,s,a,b,c)
% FIG655_3
%	Transient response and error.
%	Calculated from a normal and windowed frequency response.
%
%	Call :		fig655_3(m,N,X,s,a,b,c);
%
%	where:		m = frequency vector denormalization factor
%			N = frequency and time vector length
%			X = system order
%			s = 0 for impulse- and 1 for step-response
%			    
%			    amplitude normalization and correction options :
%			a = 1 ==>	Ix=Ix/N
%			b = 1 ==>	Ix(1)=2*pi*m
%			c = 1 ==>	Ix=[0, Ix(1:N-1)]

% RXon, 000215

if nargin < 7
	c = 0 ;
end
if nargin < 6
	b = 0 ;
end
if nargin < 5
	a = 0 ;
end
if nargin < 4
	s = 0 ;
end
if nargin < 3
	X=1;
end
if nargin < 2
	N=256;
end
if nargin < 1
	m=8;
end

% ----- system and domain vector setup ----- ;
[z,p]=buttap(X);
w=(0:1:N-1)/m;
delta_t = 2 * pi * m / N ;
t = delta_t * (0:1:N-1) ;
x=max(find(t<=5));

% ----- window function setup ----- ;
W=(1+cos(pi*(0:1:N-1)/(N-1)))/2;

% ----- frequency response ----- ;
F=freqw(z,p,w);
% plot(w,abs(F),'-r',w,abs(F.*W),'-b'),pause
G=abs(F(1));

% ----- impulse responses, normal and windowed ----- ;
In=2*real(fft(conj(F)))-1;
Iw=2*real(fft(conj(F.*W)))-1;

% ----- ideal (reference) impulse response ----- ;
if X == 1
	% ----- first-order system amplitude correction ----- ;
	Id = exp( -t ) ;
	if b
		In(1)=In(1)*(1+m/(m+1));
		Iw(1)=2*pi*m;
	end
else
	% ----- second and higher order system ----- ;
	Id = tdr( z, p, t, 'i' );
	In(1)=0;
	Iw(1)=0;
end

% ----- amplitude normalization ----- ;
if a
	Id=2*pi*m*Id/(N-1);
	In=In/((N-1)*(2*G-1));
	Iw=Iw/((N-1)*(2*G-1));
else
%	Id=Id*2*(N-1)/(m+1);
	Id=Id*2*pi*m;
end

% ----- force causality, optionally for impulse, obligatory for step ----- ;
if c | s
	Id = Id * ( 1 - pi*m/N ) ; 
	In = In * ( 1 - pi*m/N ) ;
	Iw = Iw * ( 1 - pi*m/N ) ;
	Id = [ 0, Id(1:N-1) ] ;
	In = [ 0, In(1:N-1) ] ;
	Iw = [ 0, Iw(1:N-1) ] ;
end


% ----- step-response ----- ;
if s == 1
	In = cumsum(In) ;
	Iw = cumsum(Iw) ;
	Id = cumsum(Id) ;
	x=N;
end

disp(' ');
disp('    k         In(k)     Iw(k)     Id(k)');
disp('----------------------------------------------');
disp([1,In(1), Iw(1), Id(1)]);
disp([2,In(2), Iw(2), Id(2)]);
disp([3,In(3), Iw(3), Id(3)]);
disp([N/2,In(N/2), Iw(N/2), Id(N/2)]);
disp([N,In(N), Iw(N), Id(N)]);
disp('----------------------------------------------');
disp(' ');
disp('    2*pi*m    N/2pim');
disp('----------------------------------------------');
disp([2*pi*m,N/(2*pi*m)]);

figure;
plot(t(1:x),Id(1:x),'-r',t(1:x),In(1:x),'-g',t(1:x),Iw(1:x),'-b')

% if X == 1
% 	In=In/max(In);
% 	Iw=Iw/max(Iw);
% 	Id=Id/max(Id);
% end
% 
% figure;
% plot(t(1:x),Id(1:x),'-r',t(1:x),In(1:x),'-g',t(1:x),Iw(1:x),'-b')

figure;
plot(t(1:x),In(1:x)-Id(1:x),'-g',t(1:x),Iw(1:x)-Id(1:x),'-b')
