function testtr(x,N,m)
% TESTTR	Test TTRESP Routine.
%
%		Call :		testtr(x)
%		where:		x --> Butterworth system order number

% RXon, 000304

if nargin < 3
	m=8;
end
if nargin < 2
	N=256;
end
if ~nargin
	x=1;
end

[z,p]=buttap(x);
w=(0:1:N-1)/m;
F=freqw(z,p,w);

[y,t]=ttresp(F,w,'i');
u=ttresp(F,w,'u');
s=ttresp(F,w,'s');

% t=t-t(2)/8;

q=tdr(z,p,t,'i');
r=tdr(z,p,t,'n');
d=tdr(z,p,t,'s');

k=10;
v=N/8;
figure;
plot(t(1:v),q(1:v),t(1:v),y(1:v),t(1:v),k*abs(y(1:v)-q(1:v))/max(q))

figure;
plot(t(1:v),r(1:v),t(1:v),u(1:v),t(1:v),k*abs(u(1:v)-r(1:v))/max(r))

figure;
plot(t(1:v),d(1:v),t(1:v),s(1:v),t(1:v),k*abs(s(1:v)-d(1:v))/max(d))
