function fig67x
% FIG67X		Fig.6.7.1, 2 and 3 :
%				Comparison of 5th-order Butterworth
%				and Bessel-Thomson system.

% RXon, 001102

[z1,p1]=buttap(5);
[z2,p2]=bestap(5,'n');

figure(1);
plot([-2,2],[0,0],'-k',[0,0],[-2,2],'-k');
hold on;
ellipfit(p1, 1, '*r', '-g');
ellipfit(p2, 1, '*b', '-g');
axis equal square ;
axis([-2,2,-2,2]);
xlabel('\Re\{\its\rm\}');
ylabel('\Im\{\its\rm\}');

figure(2)
w=logspace(-1,1,301);
M1=20*log10(abs(freqw(p1,w)));
M2=20*log10(abs(freqw(p2,w)));
semilogx(w,M1,'-r',w,M2,'-b')
axh=gca;
set(axh,'XTickLabel',[' 0.1';' 1.0';'10.0']);
xlabel('Normalized Frequency');
ylabel('Magnitude [dB]');

figure(3)
t=(0:1:160)/10;
S1=atdr(z1,p1,t);
S2=atdr(z2,p2,t);
plot(t,S1,'-r',t,S2,'-b')
axis([0,16,0,1.2]);
xlabel('Normalized Time');
ylabel('Normalized Amplitude');
