% Fig. 6.3.1-4
%	Impulse Response in time and frequency domain.


N = 128 ;
M = 30 ;
x = [ zeros( 1, M ), N, zeros( 1, N-M-1 ) ] ;
t = ( -M : 1 : N-M-1 ) ;

subplot
subplot(221)
plot([t(1:M+1) 0 1 t(M+2:N)],[x(1:M) 0 N x(M+1:N)],[1],[-N/10])
% plot( t, x, 0, -1 )
axh=axis([-M,100,-50,150]);
set(axh,'XTickMode','Manual','XTickLabelMode','Manual');
set(axh,'XTick',[-30,0,30,60,90],'XTickLabels',['-30';'  0';' 30';' 60';' 90']);
set(axh,'YTickMode','Manual','YTickLabelMode','Manual');
set(axh,'YTick',[-50,0,50,100,150],'YTickLabels',['-50';'  0';' 50';'100';'150']);
% xlabel( 'Time' )
text( 0, -30, 'Time' )
% title( 'Input Impulse' )
text( 15, 125, 'Input Impulse' )

X=fft(x)/N;
XX=abs(X(:).');
XX=XX(1:N/2);
XX=[XX;zeros(size(XX));zeros(size(XX));zeros(size(XX));zeros(size(XX))];
XX=XX(:);
w=(0:1:N-1);
ww=w(:).';
ww=ww(1:N/2);
ww=[ww;ww;ww+1/3;ww+2/3;ww+1];
ww=ww(:);
subplot(223)
plot(ww,1.003*XX)
axh=axis( [ 0, 70, 0, 1.5 ] ) ;
set(axh,'XTickMode','Manual','XTickLabelMode','Manual');
set(axh,'Xtick',[0,20,40,60],'XTickLabels',[' 0';'20';'40';'60'] ) ;
xlabel( 'Frequency' )
% title( 'Input Spectrum' )
text( 10, 1.25, 'Input Spectrum' )


[z,p]=buttap(5);
F=freqw(p,w/8);
[S,I,t]=tresp(F,w/8);
t=( 0 : 1 : N-1 ) - M + 1 ;
I=N*I/sum(I);
I=[zeros(1,M) I(1:1:N-M)];
subplot(222)
plot(t,I)
axh=axis([-30,100,-10,20]);
set(axh,'XTickMode','Manual','XTickLabelMode','Manual');
set(axh,'XTick',[-30,0,30,60,90],'XTickLabels',['-30';'  0';' 30';' 60';' 90']);
% xlabel( 'Time' )
text( 0, -7, 'Time' )
% title( 'Impulse Response' )
text( 25, 17, 'Impulse-' ) ;
text( 25, 13, '-Response' )


XF=abs(X.*F);
XF=XF(:).';
XF=XF(1:N/2);
XF=[XF;zeros(size(XF));zeros(size(XF));zeros(size(XF));zeros(size(XF))];
XF=XF(:);
subplot(224)
plot(ww,1.01*XF)
axh=axis( [ 0, 70, 0, 1.5 ] ) ;
set(axh,'XTickMode','Manual','XTickLabelMode','Manual');
set(axh,'XTick',[0,20,40,60],'XTickLabels',[' 0';'20';'40';'60'] ) ;
xlabel( 'Frequency' )
% title( 'Response Spectrum' )
text( 10, 1.25, 'Response Spectrum' )
