function fig64
% Fig. 6.4.1-2
%	Butterworth systems from 1st to 10th order.
%	Impulse and step responses.

figure ;
w=(0:1:255)/8;

for N = 1:1:10
	[z,p]=buttap(N);
	H=freqw(z,p,w);
	[S,I,t]=tresp(H,w);
	if N == 1
		x = min( find( t > 20 ) ) - 1 ;
	end
	t=t(1:x);
	I=I(1:x);
	S=S(1:x);
	subplot(2,1,1);
	plot(t,I,'-k');
	hold on
	subplot(2,1,2);
	plot(t,S,'-k');
	hold on
end

subplot(2,1,1)
axh=gca;
axis( [0, 20, -0.2, 1 ] ) ;
text( 12, -0.4, 'Time' ) ;
% set( axh, 'YTickMode','Manual','YTickLabelMode','Manual' ) ;
% set( axh, 'YTick', [-0.2,0,0.2,0.4,0.6,0.8,1],'YTickLabels',['-0.2';'   0';' 0.2';' 0.4';' 0..6';' 0.8';' 1.0']);

subplot(2,1,2)
axh=gca;
axis( [0, 20, 0, 1.2 ] ) ;
text( 12, -0.2, 'Time' ) ;
% set( axh, 'YTickMode','Manual','YTickLabelMode','Manual' ) ;
% set( axh, 'YTick', [0,0.2,0.4,0.6,0.8,1,1.2],'YTickLabels',['  0';'0.2';'0.4';'0.6';'0.8';'1.0','1.2']);

