function fig642( tp,qx )
% FIG642	test of Fig.6.4.2. - test the display and graphics file size.
%			Fig.6.4.2.: 5th-order Butterworth complex-frequency response magnitude
%			over the s-plane.

% RXon, 880217
% Matlab-V revision : 000820

% get Matlab version number :
if ~exist('version')
	matver='1.0';
else
	matver=version;
end
matver=str2num(matver(1));

if nargin < 2
	qx = 50 ;
end
if nargin < 1
	tp = 1 ;
end

[z,p]=buttap(5);	% a 5th order Butterworth system zeros and poles
[row,col]=size(p);


% -------------- Fig.6.1.3. ---------------- ;
% ----- 3-D Magnitude over the s-plane ----- ;
figh=figure(3) ;
re=-2;
im=2;
hh=12;
xyz( z, p, re, im, hh, qx, tp ) ;
axis([re,0,-im,im,0,hh]);

if matver < 4
	text( -1.2, 0.5, 12, 'up to infinity' )
elseif matver == 4
	txh=text( -1.2, 0.5, 12, 'x   ' );
	set( txh, 'FontName','BCSYMA','FontSize',16,'String',setstr( [197,32,95] ) );
else
	text( -1.4, 0.6, 12, '\uparrow\infty','FontSize',10 );
end
if matver > 3
	axh=gca;
	if matver > 4
		set(axh,'ZTick',[0,3,6,9,12],'ZTickLabel',[' 0';' 3';' 6';' 9';'12']);
	else
		set(axh,'ZTick',[0,3,6,9,12],'ZTickLabels',[' 0';' 3';' 6';' 9';'12']);
	end
end

if matver < 4
	xlabel( 'sigma=Real{s}' )
elseif matver == 4
	txh=text(-1,-3,-1,'x');
	% display greek 'sigma' from the BCSYMB (WinEXP) font, instead of x :
	set(txh,'FontName','BCSYMB','FontSize',16,'String',setstr(53));
	text(-1,-3,-1,'   = Real{s}')
else
	text(-1,-3,-1,'{\it\sigma} = \Re\{{\its}\}','FontSize',10)
end   

if matver < 4
	ylabel( 'j*omega = j*Imag{s}' )
elseif matver == 4
	txh=text(0,0,-2,'  x');
	% display greek 'omega' from BCSYMB (WinEXP) font, instead of x :
	% keep the spaces for correct alignment !
	set(txh,'FontName','BCSYMB','FontSize',16,'String',['  ',setstr(61)]); % display 'omega'
	text(0,0,-2,'j    = j*Imag{s}')
else
	text(0,0,-2,'{\itj\omega} = {\itj}\Im\{{\its}\}','FontSize',10)
end

if matver < 5
	zlabel( 'M(s) = |F(s)|' )
else
	zlabel( '{\itM}({\its}) = |{\itF}({\its})|','FontSize',10)
end

%if matver < 4
%	title( ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude over s-Plane'] )
%elseif matver == 4
%	text(-1.8,-1.8,14, ['Fig. 6.1.',num2str(figh),'. :  5th-order Butterworth Magnitude over s-Plane'] )
%else
%	title( ['Fig. 6.1.',num2str(figh),'. :  5^{th}-order Butterworth Magnitude over {\its}-Plane'] )
%end   
