function fig705
%FIG705	Generate Fig.7.5.x for the Part7 of the WBAmps.
%
%	This figures are for the system design example
%	n=[5,7,9].

% RXon, 000403

% ----------- frequency-domain analysis ----------------------- ;
N=301;
A=2^12;		% ADC resolution limit sets the attenuation
w0=1e+7;		% ADC bandwidth requirement, 10MHz = Nyquist frequency
M=1e+6;
w5=w0*10^(log10(A^2-1)/(2*5));
w7=w0*10^(log10(A^2-1)/(2*7));
w9=w0*10^(log10(A^2-1)/(2*9));
disp('     w5        w7       w9    [MHz]')
disp('-----------------------------------')
disp([w5, w7, w9]/M)

w5=w0*w0/w5;
w7=w0*w0/w7;
w9=w0*w0/w9;
disp('     w5        w7       w9    [MHz]')
disp('-----------------------------------')
disp([w5, w7, w9]/M)

w=logspace(5,7,N);	% frequency (1e+5 to 1e+7 in 301 log-scale steps)

[z5,p5]=bestap(5,'a');	% BesselThomson 'asymptote' normalized systems
[z7,p7]=bestap(7,'a');	% of order 5, 7 and 9 ;
[z9,p9]=bestap(9,'a');

p5=p5*w5;			% The poles are scaled-down so that all three
p7=p7*w7;			% responses have 1/A attenuation at w=1e+6.
p9=p9*w9;

F5=20*log10(abs(freqw(p5,w)));	% Calculate magnitudes in dB ;
F7=20*log10(abs(freqw(p7,w)));
F9=20*log10(abs(freqw(p9,w)));

figure(1)
% plot magnitudes in dB vs. log-scaled frequency
% and the -3dB reference level (see Fig.6.9) :
db3=-3.0103;
semilogx( 1e-3*w, F9, '-g', ...
          1e-3*w, F5, '-r', ...
          1e-3*w, F7, '-b', ...
          1e-3*w0*[0.06, 0.3], [db3, db3], '-k', ...
          1e-3*w0*[0.01, 1], 20*log10(1/A)*[1, 1], '--k' )
axh=gca;
% xlh=get(axh,'XLabel');
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabel',[' 0.1'; ' 1.0'; '10.0']);
xlabel( 'Frequency [MHz]' )
ylabel( 'Attenuation' )

text( 1e-3*w0*0.06, -6, '-3dB' )
text( 1e-3*w0*0.02, -70, 'ADC resolution : -72dB' )
% text( 1e-3*w0*0.013, -20, 'Fig. 7.5.1.:' )
text( 1e-3*w0*0.013, -25, 'Frequency-responses, normalized to' )
text( 1e-3*w0*0.013, -30, 'equal attenuation of -72dB at the' )
text( 1e-3*w0*0.013, -35, 'Nyquist frequency (10MHz)' )

% compare the magnitudes with the -3dB level and
% find the index of the frequency limits:

m=abs(F5-db3);
x5=find(m==min(m));

m=abs(F7-db3);
x7=find(m==min(m));

m=abs(F9-db3);
x9=find(m==min(m));

w5h=w(x5);
w7h=w(x7);
w9h=w(x9);
text( 1e-3*w0*0.013, -45, 'Cut-off frequencies :' )
text( 1e-3*w0*0.020, -50, ['f5 = ', num2str( round( w5h/1000 )/1000 ), ' MHz'])
text( 1e-3*w0*0.020, -55, ['f7 = ', num2str( round( w7h/1000 )/1000 ), ' MHz'])
text( 1e-3*w0*0.020, -60, ['f9 = ', num2str( round( w9h/1000 )/1000 ), ' MHz'])

% now display the cutoff frequencies :
disp('     w5h       w7h      w9h   [MHz]')
disp('-----------------------------------')
disp([w5, w7, w9]/M)


% ----------- time-domain analysis ---------------------------- ;
fs=2*w0;		% sampling frequency
t=(0:1/(20*fs):1e-6);		% time vector
% xt=max(find(t<=6e-6));
xt=length(t);

S5=atdr(z5,2*pi*p5,t,'s');	% Step responses
S7=atdr(z7,2*pi*p7,t,'s');	% same time scale for all three responses
S9=atdr(z9,2*pi*p9,t,'s');

figure(2)
% plot the step responses with the 0.1 and 0.9 reference levels :
ts=1e+5*t(1:xt);
x1=([0.10, 0.30]*1e-6);
x2=([0.25, 0.55]*1e-6);
y10=[.1 .1];
y90=[.9 .9];
plot(  t*M,  S9, '-g', ...
       t*M,  S5, '-r', ...
       t*M,  S7, '-b', ...
      x1*M, y10, '-k', ...
      x2*M, y90, '-k' )
xlabel( 'Time [us]' )
axis([0, max(t)*M, 0, 1.2]);
% text( 40, 0.70, 'Fig. 7.5.2.:' )
text( max(t)*M*0.05, 1.15, 'Step-responses of the denormalized' )
text( max(t)*M*0.05, 1.08, '9th-, 7th- and 5th-order systems' )
text( max(t)*M*0.5, 0.55, 'Rise-times :' )

x2=min(find(S5>=0.9));
x1=max(find(S5<=0.1));
Tr5=t(x2)-t(x1);
x2=min(find(S7>=0.9));
x1=max(find(S7<=0.1));
Tr7=t(x2)-t(x1);
x2=min(find(S9>=0.9));
x1=max(find(S9<=0.1));
Tr9=t(x2)-t(x1);
text( max(t)*M*0.5, 0.45, ['Tr9 = ', num2str(round(Tr9*1e+9)), ' ns'] )
text( max(t)*M*0.5, 0.38, ['Tr7 = ', num2str(round(Tr7*1e+9)), ' ns'] )
text( max(t)*M*0.5, 0.31, ['Tr5 = ', num2str(round(Tr5*1e+9)), ' ns'] )

% ----------- aliasing suppression analysis --------------- ;
% new frequency vector(1e+5 to 1e+7 in 301 log-scale steps)
w=logspace(6,8,N);
SF=1.75;					% frequency shift factor
F70=20*log10(abs(freqw(z7,p7,w)));	% reference system
F71=20*log10(abs(freqw(z7,SF*p7,w)));	% half-octave shifted system

xw0=max(find(F70>=-80));
xw1=max(find(F71>=-80));
xwa=max(find(F71>=-72));
xwn=find(w==w0);

wa=w(xwn:xwa);		% w0 <= w <= w(F71==1/A)
F71A=F71(xwn:xwa);	% F71 > Nyquist fr.
F71AF=F71(xwa:-1:xwn);	% alias of F71A ---------------- ???

wa2=[wa; wa];	% shadowing under F71A
wa2=wa2(:).';
[r,c]=size(F71A);
F71A2=[-72*ones(r,c); F71A];
F71A2=F71A2(:).';

waf=2*w0-wa;		% alias frequency vector

waf2=[waf; waf];	% shadowing of F71AF
waf2=waf2(:).';
F71AF2=[-72*ones(r,c); F71A];
F71AF2=F71AF2(:).';

Fr=20*log10(1/A)-F71A;	% aliasing filter requirement

figure(3);
semilogx(    w(1:xw0)/M,           F70(1:xw0), '-r' , ...
         [w(1), w(N)]/M, 20*log10(1/A)*[1, 1], '--k', ...
             w(1:xw1)/M,           F71(1:xw1), '-b' , ...
                  wa2/M,                F71A2, '-b' , ...
                 waf2/M,               F71AF2, '-g' , ...
                  waf/M,                 F71A, '-g' , ...
                  waf/M,                   Fr, '-m' )
axh=gca;
% xlh=get(axh,'XLabel');
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabel',[' 1.00'; ' 10.0'; '100.0']);
xlabel( 'Frequency [MHz]' )
ylabel( 'Attenuation' )
text(  3.0, -25, 'F7o' )
text(  5.3, -25, 'F7a' )
text(  8.0, -20, 'Frq' )
text( 15.0, -56, 'Fa' )
text(  3.3, -60, 'Fs-Fa' )
% text( 1.30, -5, 'Fig.7.5.3.: Alias band' )
% text( 1.30, -9, 'suppression requirement')
text( 5.0, -5, 'Alias band suppression requirement' )
