function p7=fig7601(psl)
%FIG7601	test of the fig.7.6.x procedure but for order-9 system	
%	Construction of Fig 7.5 and 7.6. for WBAmps, Part 7.
%	Plots the frequency-response and requiremendts for the improved 13th-order
%	system in fig.7.5. and the step-response comparison of the original 7th-order
%	filter and the improved 13th-order filter.
%	The function returns teh poles P7 selected for the 7th-order analogue-part
%	of the 13th-order compound (analogue+digital) filter.
%

% RXon, 000405

fn=1e+6;				% Nyquist frequency
fs=2*fn;				% sampling frequency

A=2^12;					% ADC resolution limit sets the attenuation
f9=fn*10^(log10(A^2-1)/(2*9));		% find frequency normalization factor
f9=fn*fn/f9;				% reverse it

[z9,p9]=bestap(9,'a');			% this is our original 9th-order reference
p9=f9*p9;				% denormalized poles of reference

[z17,p17]=bestap(17,'a');		% the 17th-order system
Bi=1.60;				% the bandwidth improvement factor
p17=Bi*f9*p17;				% denormalized poles of the compound system
p17=sort(p17);

if ~nargin
	p9a=p17([1,4,5,8,9,12,13,16,17]);	% analogue fiter pole selection
	p8d=p17([2,3,6,7,10,11,14,15]);		% digital-equivalent filter poles
else
	p9a=p17([1,10,11,12,13,14,15,16,17]);	% analogue fiter pole selection
	p8d=p17([2,3,4,5,6,7,8,9]);		% digital-equivalent filter poles
end

f=logspace(5,7,301);			% 301-element log-scaled frequency vector

F90=20*log10(abs(freqw(p9,f)));		% refrence magnitude
F91=20*log10(abs(freqw(p9a,f)));	% analogue system magnitude
F8d=20*log10(abs(freqw(p8d,f)));	% digital-equivalent magnitude
F17=20*log10(abs(freqw(p17,f)));	% total a+d system magnitude

a=20*log10(1/A);			% the ADC resolution limit, -72dB
xa=max(find(F91>=a));			% response index at crossing of a
xn=151;					% index of the Nyquist frequency
fa=f(xn:xa);				% frequency at the index
Fa=F91(xn:xa);				% band above Nyquist
fb=fs-fa;				% alias of fa

% Fb=F91(xa:-1:xn);			% alias band
Fb=Fa;					% alias band

Frq=a-Fb;				% alias suppression requirement

r=max(find(F90>=-80));
s=max(find(F91>=-80));
t=max(find(F8d>=-80));
u=max(find(F17>=-80));
figure(1)
semilogx( f(1:r)/fn,  F90(1:r), '-k', ...
	  f(1:s)/fn,  F91(1:s), '-r', ...
	  f(1:t)/fn,  F8d(1:t), '-b', ...
	  f(1:u)/fn,  F17(1:u), '-m', ...
	  fa/fn,      Fa,       '-g', ...
	  fb/fn,      Fa,       '-g', ...
	  fb/fn,      Frq,      '-c', ...
	  [f(1),f(301)]/fn, [a,a], '--k' )
axh=gca;
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabels',[' 0.1';' 1.0';'10.0']);
xlabel('Frequency [MHz]')
ylabel('Magnitude [dB]')
text(4,-69, '-72dB')
text(0.4, -40, 'F90')
text(0.5, -23, 'F17')
text(0.4, -60, 'Fb')
text(2, -65, 'F8D')
text(1.2,-65, 'Fa')
text(1.0, -30, 'Frq')
text(0.6, -6, 'F91')

f30=f(max(find(F90>=-3)));
f31=f(max(find(F17>=-3)));
Bif=f31/f30;
disp([f30/fn, f31/fn,Bif])

figure(2)
t=(0:1:100)/fs;			% time vector
S90=atdr(z9,p9,t,'s');		% reference 7th-order system step-response
S17=atdr(z17,p17,t,'s');	% 13th-order step-response

% plot the step responses with the 0.1 and 0.9 reference levels,
% to aid rise-time identification :
plot( t*fn,           S90,     'r', ...
      t*fn,           S17,     'b', ...
      t([15 35])*fn,  [.1 .1], 'k', ...
      t([40 60])*fn,  [.9 .9], 'k' )
xlabel('Time [us]')
xt1=max(find(S90<=0.1));
xt2=max(find(S90<=0.9));
xt3=max(find(S17<=0.1));
xt4=max(find(S17<=0.9));
tr70=t(xt2)-t(xt1);
tr13=t(xt4)-t(xt3);
text(30,0.75,'Rise-times :')
text(30,0.60,['tr70=',num2str(tr70*fn),'us'])
text(30,0.45,['tr13=',num2str(tr13*fn),'us'])

figure(3)
% calculate the group delay for the original 7th- and improved 13th-order system :
gd90=groupdly(z9,p9,f);
gd17=groupdly(z17,p17,f);
semilogx( f/fn, gd90*1e+6, '-r', ...
	  f/fn, gd17*1e+6, '-b') %, ...
axh=gca;
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabels',[' 0.1';' 1.0';'10.0']);
xlabel( 'Frequency [MHz]' ) ;
ylabel( 'Group-Delay [us]' ) ;

p9a
p8d


figure(4)
% convolution as digital filtering :
l=60;
x9a=atdr( z9, p9a, t, 's' ) ;
h8d=atdr( z9, p8d, t, 'n' ) ;
% plot(h8d), pause
h8d=h8d(1:l);
y17=conv(x9a,h8d);
y17=y17(1:max(size(t)));
plot( t*1e+6, x9a, 'xr', t(1:l)*1e+6, 0.5*h8d/max(h8d), 'og', t*1e+6, y17, '*b' )
xlabel( 'Time [us]' )

