function [p7a,p6d]=fig7602(psl)
%FIG7601	test of the fig.7.6.x procedure.
%	Construction of Fig 7.3.4, 5, 6 and 7 for WBAmps,
%	Part 7.
%

% RXon, 010114

if ~nargin
	psl=0;				% pole selection flag
end
fs=2e+7;				% sampling frequency, 20MHz
fn=fs/2;				% Nyquist frequency
fM=1e+6;				% MHz-us conversion factor
t=(0:1/fs:1e-6);	% time vector
T=(0:1/(10*fs):1e-6);	% interpolated time vector
nt=length(t)

A=2^12;				% ADC resolution limit sets the attenuation
						% find frequency normalization factor
f7=fn*10^(log10(A^2-1)/(2*7));
f7=fn*fn/f7;			% reverse it

						% this is our original 9th-order reference
[z7,p7]=bestap(7,'a');
p7=2*pi*f7*p7;		% denormalized poles of reference

						% the 17th-order system
[z13,p13]=bestap(13,'a');
Bi=1.73;				% the bandwidth improvement factor
p13=2*pi*Bi*f7*p13;	% denormalized poles of the compound system
p13=sort(p13);		% sort in ascending order

if ~psl
	p7a=p13([1,4,5,8,9,12,13]);	% analogue fiter pole selection
	p6d=p13([2,3,6,7,10,11]);		% digital-equivalent filter poles
else
	p7a=p13([1,8,9,10,11,12,13]);% analogue fiter pole selection
	p6d=p13([2,3,4,5,6,7]);		% digital-equivalent filter poles
end

f=logspace(6,8,301);			% 301-element log-scaled frequency vector

F7o=20*log10(abs(freqw(p7,2*pi*f)));	% refrence magnitude
F7a=20*log10(abs(freqw(p7a,2*pi*f)));	% analogue system magnitude
F6d=20*log10(abs(freqw(p6d,2*pi*f)));	% digital-equivalent magnitude
F13=20*log10(abs(freqw(p13,2*pi*f)));	% total a+d system magnitude

a=20*log10(1/A);		% the ADC resolution limit, -72dB
xa=max(find(F7a>=a));	% response index at crossing of a
xn=151;					% index of the Nyquist frequency
fa=f(xn:xa);				% frequency at the index
Fa=F7a(xn:xa);			% band above Nyquist
fb=fs-fa;					% alias of fa

Fb=Fa;					% alias band

Frq=a-Fb;				% alias suppression requirement

r=max(find(F7o>=-80));
s=max(find(F7a>=-80));
u=max(find(F6d>=-80));
v=max(find(F13>=-80));
figure(1)
semilogx( f(1:r)/fM,  F7o(1:r), '-k', ...
	  f(1:s)/fM,  F7a(1:s), '-r', ...
	  f(1:u)/fM,  F6d(1:u), '-b', ...
	  f(1:v)/fM,  F13(1:v), '-m', ...
	  fa/fM,      Fa,       '-g', ...
	  fb/fM,      Fa,       '-g', ...
	  fb/fM,      Frq,      '-c', ...
	  [f(1),f(301)]/fM, [a,a], '--k' )
axh=gca;
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabel',[' 1 ';' 10';'100']);
xlabel('Frequency [MHz]');
ylabel('Magnitude [dB]');
text(40, -69, '-72dB');
text( 4, -40, 'F7o');
text( 5, -23, 'F13');
text( 4, -60, 'Fb');
text(20, -65, 'F6D');
text(12, -65, 'Fa');
text(10, -30, 'Frq');
text( 6,  -6, 'F7a');

f30=f(max(find(F7o>=-3)));
f31=f(max(find(F13>=-3)));
Bif=f31/f30;
disp(['    f30/fM,   f31/fM,    Bif :'])
disp([f30/fM, f31/fM,Bif])

figure(2)
S7o=atdr(z7,p7,T,'s');		% reference 7th-order system step-response
S13=atdr(z13,p13,T,'s');	% 13th-order step-response
t1=max(find(S7o<=0.1));
t2=max(find(S7o<=0.9));
t1=round(t1/2);
t2=round(t2-t1);
t3=round(3*t1);
t4=round(t2+2*t1);
% plot the step responses with the 0.1 and 0.9 reference levels,
% to aid rise-time identification :
plot( T*fM,           S7o,     'r', ...
      T*fM,           S13,     'b', ...
      T([t1 t3])*fM,  [.1 .1], 'k', ...
      T([t2 t4])*fM,  [.9 .9], 'k' )
axis([0, max(t)*fM, 0, 1.2]);
xlabel('Time [us]')
xt1=max(find(S7o<=0.1));
xt2=max(find(S7o<=0.9));
xt3=max(find(S13<=0.1));
xt4=max(find(S13<=0.9));
tr7o=T(xt2)-T(xt1);
tr13=T(xt4)-T(xt3);
text(fM*max(T)/2, 0.75,  'Rise-times :')
text(fM*max(T)/2, 0.60, ['tr7o=',num2str(tr7o*1e+9),'ns'])
text(fM*max(T)/2, 0.45, ['tr13=',num2str(tr13*1e+9),'ns'])

figure(3)
% calculate the group delay for the original 7th- and improved 13th-order system :
gd7o=gdly(z7,p7,2*pi*f);
gd13=gdly(z13,p13,2*pi*f);
x1=min(find(gd7o>=0.99*min(gd7o)));
x2=min(find(gd13>=0.99*min(gd13)));

semilogx( f/fM, gd7o*1e+9, '-r',...
          f/fM, gd13*1e+9, '-b',...
          [1, 1]*f(x1)/fM, [0.97, 0.60]*min(gd7o*1e+9), '-k',...
          [1, 1]*f(x2)/fM, [0.97, 0.70]*min(gd13*1e+9), '-k')

text( f(x1)/fM, 0.57*min(gd7o*1e+9),[num2str(0.01*round(100*f(x1)/fM)), ' MHz']);
text( f(x2)/fM, 0.67*min(gd13*1e+9),[num2str(0.01*round(100*f(x2)/fM)), ' MHz']);

axh=gca;
set(axh,'XTickLabelMode','manual');
set(axh,'XTickLabel',[' 1 ';' 10';'100']);
xlabel( 'Frequency [MHz]' ) ;
ylabel( 'Group-Delay [ns]' ) ;

figure(4)
% convolution as digital filtering :
l=round(nt/2);
x7a=atdr( z7, p7a, t, 's' ) ;
h6d=atdr( z7, p6d, t, 'i' ) ;
h6d=h6d(1:l);
y13=conv(x7a,h6d/sum(h6d));
y13=y13(1:nt);

k=round(length(T)/2);
X7a=atdr( z7, p7a, T, 's' ) ;
H6d=atdr( z7, p6d, T, 'i' ) ;
H6d=H6d(1:k);
Y13=conv(X7a,H6d/sum(H6d));
Y13=Y13(1:length(T));

plot( T*fM,      X7a,    '-r',...
      T(1:k)*fM, H6d/fs, '-g',...
      T*fM,      Y13,    '-b',...
      t*fM,      x7a,    'or',...
      t(1:l)*fM, h6d/fs, 'og',...
      t*fM,      y13, 'ob' )
axis([0, max(t)*fM, -0.2, 1.2]);
xlabel( 'Time [us]' )
